/*
 * Decompiled with CFR 0.152.
 */
package com.proximities.sdk;

import com.proximities.sdk.json.model.animation.AnimationData;
import com.proximities.sdk.json.model.closest_poi.BaseClosestPoi;
import com.proximities.sdk.json.model.feed.BaseFeed;
import com.proximities.sdk.json.model.log.BaseLogResponse;
import com.proximities.sdk.json.model.log.CampaignLogs;
import com.proximities.sdk.json.model.loyalty.BaseLoyalty;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.json.model.partner.BasePoi;
import com.proximities.sdk.json.model.transmitter.BaseNfc;
import com.proximities.sdk.json.model.transmitter.BaseQrCode;
import com.proximities.sdk.json.model.transmitter.BaseTransmitterResponse;
import com.proximities.sdk.json.model.transmitter_logs.TransmittersLogs;
import com.proximities.sdk.json.model.user.BaseRegisterUser;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface ProximitiesApiService {
    @GET(value="api/partners/{lat}/{long}/{radius}")
    public Call<BasePartner> getPartnersInRange(@Path(value="lat") double var1, @Path(value="long") double var3, @Path(value="radius") int var5);

    @GET(value="api/pois")
    public Call<BasePoi> getPois();

    @GET(value="api/pois/closest/{lat}/{long}")
    public Call<BaseClosestPoi> getClosestPoi(@Path(value="lat") double var1, @Path(value="long") double var3);

    @GET(value="api/animations/feed/{lat}/{long}")
    public Call<BaseFeed> getFeedPartners(@Path(value="lat") double var1, @Path(value="long") double var3, @QueryMap Map<String, Object> var5);

    @GET(value="api/transmitters/{uuid}/{major}/{minor}")
    public Call<BaseTransmitterResponse> getBeacon(@Path(value="uuid") String var1, @Path(value="major") String var2, @Path(value="minor") String var3);

    @GET(value="api/transmitters/{namespace}/{instance}")
    public Call<BaseTransmitterResponse> getEddystone(@Path(value="namespace") String var1, @Path(value="instance") String var2);

    @GET(value="api/transmitters/{uuid}/{major}/{minor}")
    public Call<BaseNfc> getNfc(@Path(value="uuid") String var1, @Path(value="major") String var2, @Path(value="minor") String var3);

    @GET(value="api/transmitters/{uuid}/{major}/{minor}")
    public Call<BaseQrCode> getQrCode(@Path(value="uuid") String var1, @Path(value="major") String var2, @Path(value="minor") String var3);

    @GET(value="api/users/animations")
    public Call<AnimationData> getCampaignsByUserAction(@Query(value="userAction") String var1);

    @GET(value="api/users/animations")
    public Call<AnimationData> getFavorites();

    @POST(value="api/logs/transmitters")
    public Call<Void> sendTransmitterLogs(@Body TransmittersLogs var1);

    @POST(value="api/logs/campaigns")
    public Call<BaseLogResponse> postLogs(@Body CampaignLogs var1);

    @POST(value="api/segmentation/users")
    public Call<BaseRegisterUser> registerUser(@Body Map<String, Object> var1);

    @POST(value="api/users/loyalties/{campaignId}/refresh")
    public Call<BaseLoyalty> refreshLoyaltyCampaign(@Path(value="campaignId") int var1);

    @POST(value="api/users/animations/{campaignId}/archive")
    public Call<Void> saveCampaign(@Path(value="campaignId") int var1);

    @DELETE(value="api/users/animations/{campaignId}")
    public Call<Void> deleteCampaign(@Path(value="campaignId") int var1);
}

