package com.proximities.sdk;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import com.proximities.sdk.activities.EmptyCampaignActivity;
import com.proximities.sdk.interfaces.NfcInterface;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.json.model.transmitter.Transmitter;
import com.proximities.sdk.util.ProximitiesConstants;

/**
 * Created by william on 09/12/16.
 */

final class ProximitiesNfcManager implements NfcInterface{

    private PSManager psManager;
    private Context context;

    ProximitiesNfcManager(Context context, Uri uri){
        this.context = context;
        psManager = PSManager.getInstance();
        // http://connect.sweepin.fr/uuid/major/minor/appId
        String[] uriQuery = uri.toString().split("\\/");
        int uriLength = uriQuery.length;
        if(uriLength > 4) {
            String currentUuidNfc = uriQuery[uriLength - 4];
            String currentMajorNfc = uriQuery[uriLength - 3];
            String currentMinordNfc = uriQuery[uriLength - 2];
            ProximitiesNetworkManager.getInstance().getNfc(this, currentUuidNfc, currentMajorNfc, currentMinordNfc);
        }
    }

    @Override
    public void onGetNfcTransmitter(Transmitter transmitter) {
        for(Campaign campaign : transmitter.getCampaigns()){
            campaign.setPoi(transmitter.getPoi().get(0));
        }
        psManager.startCampaignsDisplayFromNfc(transmitter.getCampaigns(), null, String.valueOf(transmitter.getId()));
    }

    @Override
    public void onNfcWithoutCampaign() {
        Intent intent = new Intent(context, EmptyCampaignActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(ProximitiesConstants.FROM_NFC_MANAGER_EXTRA, true);
        context.startActivity(intent);
    }

    @Override
    public void onGetNfcError() {

    }

}
