package com.proximities.sdk.util;

import com.proximities.sdk.json.model.transmitter.Transmitter;

/**
 * Created by william on 21/12/16.
 */

public class DetectedBeacon {

    private Transmitter transmitter;
    private long timestamp; // timestamp right after beacon detection

    public DetectedBeacon(Transmitter transmitter, long timestamp) {
        this.transmitter = transmitter;
        this.timestamp = timestamp;
    }

    public void reduceTimestampBy(long valueToDeduct){
        this.timestamp = this.timestamp - valueToDeduct;
    }

    public Transmitter getTransmitter() {
        return transmitter;
    }

    public void setTransmitter(Transmitter transmitter) {
        this.transmitter = transmitter;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

}
