package com.proximities.sdk.json.model.log;


import androidx.annotation.Keep;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 01/01/15.
 */
@Keep
public class Log {

    private int campaignId; // campaign id
    private String created;
    private String action;
    private String poiId;
    private String transmitterId;

    public Log(int id, String action, String created){
        this.campaignId = id;
        this.action = action;
        this.created = created;
    }

    public Log(int id, String action, String created, String poiId, String transmitterId) {
        this.campaignId = id;
        this.action = action;
        this.created = created;
        if(poiId != null){
            this.poiId = poiId;
        } else if (transmitterId != null){
            this.transmitterId = transmitterId;
        }
    }

    public int getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(int campaignId) {
        this.campaignId = campaignId;
    }

    public String getCreated() {
        return created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getPoiId() {
        return poiId;
    }

    public void setPoiId(String poiId) {
        this.poiId = poiId;
    }

    public String getTransmitterId() {
        return transmitterId;
    }

    public void setTransmitterId(String transmitterId) {
        this.transmitterId = transmitterId;
    }

}
