package com.proximities.sdk.fragment;

import androidx.fragment.app.Fragment;

import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.Utils;
import com.proximities.sdk.bridge.OnAnimationListener;
import com.proximities.sdk.interfaces.GetFavoritesInterface;
import com.proximities.sdk.json.model.transmitter.Campaign;

import java.util.List;

/**
 * Created by william on 06/11/15.
 */
public class BaseFavoritesFragment extends Fragment implements OnAnimationListener, GetFavoritesInterface{

    public void refreshFavorites(){
        Utils.getFavorites(this);
    }

    @Override
    public void onClickAnimation(Campaign campaign) {
        campaign.setFavorite(1);
        ProximitiesConfig.getInstance().openCampaign(campaign);
    }

    @Override
    public void onGetFavorites(List<Campaign> favorites) {
        //override in extends fragment
    }

    @Override
    public void onGetFavoritesError() {
        //override in extends fragment
    }
}

