package com.proximities.sdk.database;
import android.content.Context;

import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;

import com.proximities.sdk.database.dao.CampaignDao;
import com.proximities.sdk.database.dao.LogDao;
import com.proximities.sdk.database.dao.TransmitterDao;
import com.proximities.sdk.database.entities.CampaignDb;
import com.proximities.sdk.database.entities.LogDb;
import com.proximities.sdk.database.entities.TransmitterDb;

@Database(entities= {TransmitterDb.class, CampaignDb.class, LogDb.class}, version = 1)
public abstract class ProximitiesDatabase extends RoomDatabase{

    private static final String DATABASE_NAME =  "proximities_database";

    private static ProximitiesDatabase instance;

    public static synchronized ProximitiesDatabase getInstance(Context context){
        if(instance == null){
            instance = Room.databaseBuilder(context.getApplicationContext(), ProximitiesDatabase.class, DATABASE_NAME)
                    .allowMainThreadQueries()
                    .fallbackToDestructiveMigration()
                    .build();
        }
        return instance;
    }

    abstract TransmitterDao transmitterDao();
    abstract CampaignDao campaignDao();
    abstract LogDao logDao();
}
