package com.proximities.sdk.fragment.templates;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.core.content.ContextCompat;
import android.util.Base64;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.fragment.ShareFragment;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.SharedCampaign;
import com.proximities.sdk.bridge.OnUrlRequestListener;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.ProximitiesPrefs;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 30/12/14.
 */
public class RichFragment extends Fragment{

    private ImageView banner;
    private ImageView image;
    private LinearLayout textPart;
    private RelativeLayout mainLayout;
    private TextView title;
    private WebView content;
    private ProgressBar spinner;
    private FrameLayout shareBar;
    private OnUrlRequestListener urlRequestListener;
    private boolean isBannerLoaded = false;
    private boolean isImageLoaded = false;
    private boolean isWebViewLoaded = false;

    private Campaign campaign;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if(context instanceof OnUrlRequestListener){
            urlRequestListener = (OnUrlRequestListener) context;
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = getArguments();
        campaign = bundle.getParcelable(ProximitiesConstants.CAMPAIGN_EXTRA);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View v = inflater.inflate(R.layout.prxsc_template_rich_fragment, container, false);
        mainLayout = (RelativeLayout) v.findViewById(R.id.main_layout);
        banner = (ImageView) v.findViewById(R.id.banner);
        image = (ImageView) v.findViewById(R.id.image);
        textPart = (LinearLayout) v.findViewById(R.id.text_part);
        title = (TextView) v.findViewById(R.id.title);
        content = (WebView) v.findViewById(R.id.content);
        shareBar = (FrameLayout) v.findViewById(R.id.share_bar);
        spinner = (ProgressBar) v.findViewById(R.id.spinner);
        title.requestFocus();
        return v;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        displayImages();
        displayContent();
    }

    private void displayImages() {
        if (campaign.getBanner() != null && !campaign.getBanner().isEmpty()) {
            banner.setVisibility(View.VISIBLE);
            String url = BuildConfig.HOST + campaign.getBanner();
            Glide.with(getActivity()).load(url)
                    .asBitmap()
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                            banner.setImageBitmap(resource);
                            isBannerLoaded = true;
                            checkIfEveryThingIsLoaded();
                        }

                        @Override
                        public void onLoadFailed(Exception e, Drawable errorDrawable) {
                            isBannerLoaded = true;
                            checkIfEveryThingIsLoaded();
                            if(campaign.getBannerOffline()!= null && !campaign.getBannerOffline().isEmpty()) {
                                byte[] decodedString = Base64.decode(campaign.getBannerOffline(), Base64.DEFAULT);
                                banner.setImageBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length));
                            }
                            super.onLoadFailed(e, errorDrawable);
                        }
                    });
            banner.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        } else {
            isBannerLoaded = true;
            banner.setVisibility(View.GONE);
        }
        if (campaign.getImage() != null && !campaign.getImage().isEmpty()) {
            image.setVisibility(View.VISIBLE);
            String url = BuildConfig.HOST + campaign.getImage();
            Glide.with(getActivity()).load(url)
                    .asBitmap()
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                            image.setImageBitmap(resource);
                        }

                        @Override
                        public void onLoadFailed(Exception e, Drawable errorDrawable) {
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                            if(campaign.getImageOffline()!= null && !campaign.getImageOffline().isEmpty()) {
                                byte[] decodedString = Base64.decode(campaign.getImageOffline(), Base64.DEFAULT);
                                image.setImageBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length));
                            }
                            super.onLoadFailed(e, errorDrawable);
                        }
                    });
            image.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));

        } else {
            isImageLoaded = true;
            image.setVisibility(View.GONE);
        }
    }

    private void displayContent() {
        int textColor = ContextCompat.getColor(getActivity(), android.R.color.black);  // TODO define a default content font color
        if (campaign.getContentFontColor() != null && !campaign.getContentFontColor().isEmpty()) {
            textColor = Color.parseColor(campaign.getContentFontColor());
        }
        if (campaign.getTopbarTitle() != null && !campaign.getTopbarTitle().isEmpty()) {
            //title.setVisibility(View.VISIBLE);
            title.setText(campaign.getTopbarTitle());
            title.setTextColor(textColor);
        } else {
            title.setVisibility(View.GONE);
        }
        if (campaign.getContentText() != null && !campaign.getContentText().isEmpty()) {
            content.setVisibility(View.VISIBLE);
            content.setBackgroundColor(Color.TRANSPARENT);
            String myHtml = "<html><head>"
                    + "<style type=\"text/css\">body{color: " + campaign.getContentFontColor() + ";}"
                    + "</style>"
                    + "</head>"
                    + "<body>"
                    + campaign.getContentText()
                    + "</body></html>";
            content.loadDataWithBaseURL(null, myHtml, "text/html", "UTF-8", null);
            content.setWebViewClient(new WebViewClient() {
                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if(Patterns.WEB_URL.matcher(url).matches()) {
                        boolean isUrlHandled = false;
                        if(ProximitiesConfig.getInstance() != null){
                            if(ProximitiesConfig.getOnCampaignURLClickListener() != null) isUrlHandled = ProximitiesConfig.getOnCampaignURLClickListener().onCampaignURLCLick(url);
                        }
                        if(!isUrlHandled)
                            urlRequestListener.displayUrlView(url);
                    } else {
                        Intent callIntent = new Intent(Intent.ACTION_DIAL);
                        callIntent.setData(Uri.parse("tel:" + url));
                        startActivity(callIntent);
                    }
                    return true;
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    isWebViewLoaded = true;
                    checkIfEveryThingIsLoaded();
                    super.onPageFinished(view, url);
                }
            });
            // content.setText(Html.fromHtml(campaign.getContentText()));
            // content.setTextColor(textColor);
        } else {
            isWebViewLoaded = true;
            content.setVisibility(View.GONE);
        }
        if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
            textPart.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
            mainLayout.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        }
        if (campaign.getTemplateType().equals(ProximitiesConfig.RICH_CAMPAIGN)) {
            if(ProximitiesPrefs.readShareFragment(getActivity()) != null && !ProximitiesPrefs.readShareFragment(getActivity()).isEmpty()) {
                shareBar.setVisibility(View.VISIBLE);
                if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
                    shareBar.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
                }
                try {
                    ShareFragment shareFragment = (ShareFragment) Class.forName(ProximitiesPrefs.readShareFragment(getActivity())).newInstance();
                    shareFragment.setSharedCampaign(new SharedCampaign(campaign.getType(), campaign.getTitle(), ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getImage(), campaign.getContentBackgroundColor(), campaign.getContentFontColor()));
                    getFragmentManager().beginTransaction()
                            .replace(R.id.share_bar, shareFragment, "share")
                            .commit();
                } catch (java.lang.InstantiationException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        } else {
            shareBar.setVisibility(View.GONE);
        }
    }

    private void checkIfEveryThingIsLoaded(){
        if(isWebViewLoaded && isImageLoaded && isBannerLoaded){
            spinner.setVisibility(View.GONE);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if(campaign != null && content != null){
            content.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if(campaign != null && content != null){
            content.onPause();
        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        if(campaign != null && content != null){
            content.destroy();
        }
    }
}
