package com.proximities.sdk.activities;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Build;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;

import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.model.appointments.Appointment;
import com.proximities.sdk.util.ProximitiesConstants;

public class AppointmentDialogActivity extends AppCompatActivity {

    private Appointment mAppointment;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }
        handleIntent(getIntent());
        setContentView(R.layout.activity_appointment_dialog);
        getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        this.setFinishOnTouchOutside(false);
        initSimpleNotificationDesign();
    }

    private void handleIntent(Intent intent) {
        if(intent.getExtras() != null) {
            mAppointment = intent.getParcelableExtra(ProximitiesConstants.APPOINTMENT_EXTRA);
        }
    }

    private void initSimpleNotificationDesign(){
        TextView title = (TextView) findViewById(R.id.title);
        TextView message = (TextView) findViewById(R.id.message);
        if (mAppointment.getContentTemplate().getTitle() != null && !mAppointment.getContentTemplate().getTitle().equals("")) {
            title.setText(mAppointment.getContentTemplate().getTitle());
        }
        message.setText(mAppointment.getContentTemplate().getContentText());

        Button btnPositive = (Button) findViewById(R.id.positive_button);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            final float scale = getApplicationContext().getResources().getDisplayMetrics().density;
            int pixels = (int) (8 * scale + 0.5f);
            btnPositive.setElevation(pixels);
        }
        btnPositive.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
                if(ProximitiesConfig.getOnCatchDestinationListener() != null) {
                    ProximitiesConfig.getOnCatchDestinationListener().onCatchDestination(mAppointment.getIpsTriggerInfo().getId());
                }
            }
        });

        ImageButton btnClose = (ImageButton) findViewById(R.id.close_button);
        btnClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });
    }
}
