package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.bridge.OnRetrievePartnersListener;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.model.feed.BaseFeed;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 08/12/15.
 */
public final class FeedRequest implements Response.Listener<BaseFeed>, Response.ErrorListener {

    private static final String TAG = makeLogTag(FeedRequest.class);

    private Context context;
    private String wsFeed;
    private OnRetrievePartnersListener mCallback;

    public FeedRequest(Context context, OnRetrievePartnersListener callback) {
        this.context = context;
        this.mCallback = callback;
        wsFeed = BuildConfig.HOST + context.getString(R.string.prxsc_ws_feed);
    }

    public void executeGet(double latitude, double longitude, int page, int nbElmts){
        String url = wsFeed + "/" + latitude + "/" + longitude+"?page=" + page + "&size=" + nbElmts;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + url);
        GsonRequest<BaseFeed> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseFeed.class,
                params,
                this,
                this);
        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    public void executeGet(String url){
        String fullUrl = wsFeed + url;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + fullUrl);
        GsonRequest<BaseFeed> request = new GsonRequest(
                Request.Method.GET,
                fullUrl,
                BaseFeed.class,
                params,
                this,
                this);
        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseFeed baseFeed) {
        if(mCallback != null){
            mCallback.onRetrievePartners(baseFeed.getData().getPartners());
        }
    }

    @Override
    public void onErrorResponse(VolleyError error) {
        if(mCallback != null){
            mCallback.onRetrievePartnersError(new String(error.networkResponse.data));
        }
    }
}
