package com.proximities.sdk.request;

import android.content.Context;
import android.util.Base64;
import com.proximities.sdk.util.Utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import static com.proximities.sdk.util.LogUtils.makeLogTag;

public final class UrlSigner {

    private static final String TAG = makeLogTag(UrlSigner.class);

    private static final UrlSigner ourInstance = new UrlSigner();

    // This variable stores the binary key, which is computed from the string (Base64) key
    private static byte[] key;
    private final static char[] hexArray = "0123456789abcdef".toCharArray();

    public static UrlSigner getInstance() {
        return ourInstance;
    }

    public static String sign(Context ctx, String msgToSign) throws IOException, InvalidKeyException, NoSuchAlgorithmException, URISyntaxException {
        // key = Base64.decode(SweepinConstants.HASH_KEY, Base64.URL_SAFE | Base64.NO_WRAP);
        key = Utils.getAppSecret(ctx).getBytes("UTF-8");
        String request = signRequest(msgToSign);

        // LOGD(TAG, "Hashkey :" + SweepinConstants.HASH_KEY);
        // LOGD(TAG, "msgToSign :" + msgToSign);
        // LOGD(TAG, "key :" + key);
        // LOGD(TAG, "Signed URL :" + request);
        return request;
    }

    private static String signRequest(String resource) throws NoSuchAlgorithmException, InvalidKeyException,
            UnsupportedEncodingException, URISyntaxException {

        // Get an HMAC-SHA1 signing key from the raw key bytes
        SecretKeySpec sha1Key = new SecretKeySpec(key, "HmacSHA1");

        // Get an HMAC-SHA1 Mac instance and initialize it with the HMAC-SHA1 key
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(sha1Key);

        // compute the binary signature for the request
        byte[] sigBytes = mac.doFinal(resource.getBytes());

        // base 64 encode the binary signature
        // String signature = Base64.encodeToString(sigBytes, Base64.URL_SAFE | Base64.NO_WRAP);
        String signature = Base64.encodeToString(sigBytes, Base64.NO_WRAP);

        // convert the signature to 'web safe' base 64
        // signature = signature.replace('+', '-');
        // signature = signature.replace('/', '_');

        return signature;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int v;
        for (int j = 0; j < bytes.length; j++) {
            v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0x0F];
        }
        return new String(hexChars);
    }
}
