package com.proximities.sdk.activities;

import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

import com.proximities.sdk.R;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.Utils;

/**
 * Created by william on 09/12/16.
 */

public class EmptyCampaignActivity extends AppCompatActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.prxsc_empty_campaign_activity);
        boolean fromNfc = getIntent().getBooleanExtra(ProximitiesConstants.FROM_NFC_MANAGER_EXTRA, false);
        boolean fromQr = getIntent().getBooleanExtra(ProximitiesConstants.FROM_QR_MANAGER_EXTRA, false);
        TextView content = (TextView) findViewById(R.id.text_content);
        if(fromNfc){
            content.setText(getString(R.string.prxsc_empty_nfc_content));
        } else if(fromQr){
            content.setText(getString(R.string.prxsc_empty_qr_content));
        }
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        toolbar.setTitle("");
        setSupportActionBar(toolbar);
        Drawable closeDrawable = ContextCompat.getDrawable(this, R.drawable.prxsc_ic_clear);
        closeDrawable.setColorFilter(new PorterDuffColorFilter(ContextCompat.getColor(getApplicationContext(), R.color.prxsc_multi_campaign_title), PorterDuff.Mode.MULTIPLY));
        toolbar.setNavigationIcon(closeDrawable);
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });
        if(getSupportActionBar() != null){
            getSupportActionBar().setBackgroundDrawable(new ColorDrawable(ContextCompat.getColor(this, R.color.prxsc_multi_campaign_toolbar)));
        }
        if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && Utils.isColorDark(R.color.prxsc_multi_campaign_toolbar)) {
            Window window = this.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.setStatusBarColor(ContextCompat.getColor(this, R.color.prxsc_multi_campaign_toolbar));
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}
