package com.proximities.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.ProximitiesPrefs;

/**
 * Created by william on 08/07/15.
 */
public class BootReceiver extends BroadcastReceiver {

    Context mContext;
    private final String BOOT_ACTION = "android.intent.action.BOOT_COMPLETED";

    @Override
    public void onReceive(Context context, Intent intent) {
        mContext = context;
        String action = intent.getAction();
        if (action.equalsIgnoreCase(BOOT_ACTION)) {
            startService();
        }

    }

    private void startService() {
        if(!ProximitiesPrefs.readServiceIsStopped(mContext)){
            if(android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
                Intent mServiceIntent = new Intent(mContext, ProximitiesService.class);
                mServiceIntent.putExtra(ProximitiesConstants.BOOT_INTENT_EXTRA, true);
                mContext.startService(mServiceIntent);
            }
        }
    }
}
