package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.transmitter_logs.TransmittersLogs;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

import java.util.Map;


/**
 * Created by william on 08/02/16.
 */
public class EntryExitLogRequest implements Response.Listener<WsHeader>, Response.ErrorListener  {

    private static final String TAG = makeLogTag(EntryExitLogRequest.class);

    private Context ctx;
    private String wsTransmitterLogs;

    public EntryExitLogRequest(Context context) {
        this.ctx = context;
        wsTransmitterLogs = BuildConfig.HOST + context.getString(R.string.prxsc_ws_transmitters_logs);
    }

    public void sendTransmittersLogs(TransmittersLogs logs) {
        LOGD(TAG, "GET : " + wsTransmitterLogs);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + wsTransmitterLogs);
        GsonRequest<WsHeader> request = new GsonRequest(
                Request.Method.POST,
                wsTransmitterLogs,
                logs,
                WsHeader.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(WsHeader response) {

    }

    @Override
    public void onErrorResponse(VolleyError error) {

    }
}
