package com.proximities.sdk.corekit;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;

import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.corekit.interfaces.ActivityCallbacksInterface;

/**
 * Created by william on 30/11/16.
 */

public class CoreKitInstance {

    private static CoreKitInstance sharedInstance = null;
    private Application mCurrentApp;
    private RequestQueue mRequestQueue;
    private boolean isAppInForeground;
    private boolean hasAppJustBeenOpened;
    private ActivityCallbacksInterface mActivityCallbacks;

    public static CoreKitInstance initInstance(Application app){
        if(sharedInstance == null){
            sharedInstance = new CoreKitInstance(app);
        }
        return sharedInstance;
    }

    public static CoreKitInstance getSharedInstance(){
        return sharedInstance;
    }

    private CoreKitInstance(Application app){
        mCurrentApp = app;
        hasAppJustBeenOpened = true;
        registerActivityCallbacks();
    }

    private void registerActivityCallbacks(){
        mCurrentApp.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(Activity activity, Bundle bundle) {

            }

            @Override
            public void onActivityStarted(Activity activity) {
            }

            @Override
            public void onActivityResumed(Activity activity) {
                if(hasAppJustBeenOpened){
                    hasAppJustBeenOpened = false;
                    if(ProximitiesConfig.getOnAccessLocationListener() != null){
                        ProximitiesConfig.getInstance().askLocationPermission(ProximitiesConfig.getOnAccessLocationListener());
                    }
                }
                isAppInForeground = true;
                if(mActivityCallbacks != null){
                    mActivityCallbacks.onActivityResumed(activity);
                }
            }

            @Override
            public void onActivityPaused(Activity activity) {
                isAppInForeground = false;
            }

            @Override
            public void onActivityStopped(Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {

            }

            @Override
            public void onActivityDestroyed(Activity activity) {

            }
        });
    }

    public void attachActivityCallbackInterface(ActivityCallbacksInterface callback){
        this.mActivityCallbacks = callback;
    }

    /*GETTER SETTER*/

    public Application getCurrentApplication(){
        return mCurrentApp;
    }

    public RequestQueue getRequestQueue() {
        if(mRequestQueue == null){
            mRequestQueue = Volley.newRequestQueue(mCurrentApp.getApplicationContext());
        }
        return mRequestQueue;
    }

    public boolean isAppInForeground() {
        return isAppInForeground;
    }

    public void setAppInForeground(boolean appInForeground) {
        isAppInForeground = appInForeground;
    }

}
