package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.interfaces.LogDatabaseInterface;
import com.proximities.sdk.json.model.log.BaseLogResponse;
import com.proximities.sdk.json.model.log.CampaignLogs;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.LogUtils;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 01/01/15.
 */
public final class LogDatabaseRequest implements Response.Listener<BaseLogResponse>, Response.ErrorListener {

    private static final String TAG = LogUtils.makeLogTag(LogDatabaseRequest.class);
    private Context ctx;
    private String wsLogs;
    private LogDatabaseInterface mCallback;

    public LogDatabaseRequest(Context ctx, LogDatabaseInterface callback) {
        this.ctx = ctx;
        this.mCallback = callback;
        wsLogs = BuildConfig.HOST + ctx.getString(R.string.prxsc_ws_logs);
    }

    public void executePost(CampaignLogs logs) {
        LOGD(TAG, "POST : " + wsLogs);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + wsLogs);
        GsonRequest<BaseLogResponse> request = new GsonRequest(
                Request.Method.POST,
                wsLogs,
                logs,
                BaseLogResponse.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseLogResponse baseLogs) {
        if(mCallback != null){
            mCallback.onSendLogFromDatabaseSuccess();
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null){
            mCallback.onSendLogFromDatabaseError();
        }
    }

}
