package com.proximities.sdk.corekit.utils;

import android.os.Build;
import android.text.Html;

/**
 * Created by william on 01/12/16.
 */

public abstract class CKUtils {

    public static String fromHtml(String source){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            return Html.fromHtml(source, Html.FROM_HTML_MODE_LEGACY).toString();
        } else {
            return Html.fromHtml(source).toString();
        }
    }

    public static boolean isIncompatibleDevice(){
        return (Build.MANUFACTURER.toLowerCase().contains("infinix") || Build.MODEL.toLowerCase().contains("infinix")) && android.os.Build.VERSION.SDK_INT == Build.VERSION_CODES.M;
    }
}
