package com.proximities.sdk.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

/**
 * Created by william on 10/08/15.
 */
public class DatabaseHandler extends SQLiteOpenHelper {

    private static final int DATABASE_VERSION = 3;
    private static final String DATABASE_NAME = "proximities_animations.db";

    private static final String ANIMATIONS_TABLE_CREATE =

            "CREATE TABLE " + CampaignsTable.CampaignsEntry.TABLE_NAME + " (" +
                    CampaignsTable.CampaignsEntry.COLUMN_KEY + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
                    CampaignsTable.CampaignsEntry.COLUMN_TRANSMITTER_ID + " INTEGER, " +
                    CampaignsTable.CampaignsEntry.COLUMN_BEACON_UUID + " TEXT, " +
                    CampaignsTable.CampaignsEntry.COLUMN_BEACON_MINOR + " INTEGER, "+
                    CampaignsTable.CampaignsEntry.COLUMN_BEACON_MAJOR + " INTEGER, " +
                    CampaignsTable.CampaignsEntry.COLUMN_BEACON_NAMESPACE + " TEXT, " +
                    CampaignsTable.CampaignsEntry.COLUMN_BEACON_INSTANCE + " TEXT, " +
                    CampaignsTable.CampaignsEntry.COLUMN_ANIMATION_OBJECT + " BLOB);";

    private static final String ANIMATIONS_TABLE_DROP = "DROP TABLE IF EXISTS " + CampaignsTable.CampaignsEntry.TABLE_NAME + ";";

    private static final String ANIMATIONS_LOGS_TABLE_CREATE =
            "CREATE TABLE " + LogsTable.LogsEntry.TABLE_NAME + " (" +
                    LogsTable.LogsEntry.COLUMN_KEY + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
                    LogsTable.LogsEntry.COLUMN_CAMPAIGN_ID + " INTEGER, " +
                    LogsTable.LogsEntry.COLUMN_CREATED + " TEXT, "+
                    LogsTable.LogsEntry.COLUMN_ACTION + " TEXT, " +
                    LogsTable.LogsEntry.COLUMN_TRANSMITTER_ID + " TEXT, " +
                    LogsTable.LogsEntry.COLUMN_POI_ID + " TEXT);";

    private static final String ANIMATIONS_LOGS_TABLE_DROP = "DROP TABLE IF EXISTS " + LogsTable.LogsEntry.TABLE_NAME + ";";

    public DatabaseHandler(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(ANIMATIONS_TABLE_CREATE);
        db.execSQL(ANIMATIONS_LOGS_TABLE_CREATE);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(ANIMATIONS_TABLE_DROP);
        db.execSQL(ANIMATIONS_LOGS_TABLE_DROP);
        onCreate(db);
    }
}