/*
 * Decompiled with CFR 0.152.
 */
package it.yobibit.jaxb;

import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import it.yobibit.jaxb.Command;
import it.yobibit.jaxb.LombokCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.xml.sax.ErrorHandler;

public class LombokPlugin
extends Plugin {
    public static final String OPTION_NAME = "Xlombok";
    private final Command defaultCommand;
    private final Map<String, Command> commands = new HashMap<String, Command>();

    public LombokPlugin() {
        this.defaultCommand = new LombokCommand("Data", Getter.class, Setter.class, EqualsAndHashCode.class, ToString.class);
        this.addCommand(this.defaultCommand);
        this.addLombokCommand("Getter", Getter.class);
        this.addLombokCommand("Setter", Setter.class);
        this.addLombokCommand("GetterSetter", Getter.class, Setter.class);
        this.addLombokCommand("ToString", ToString.class);
        this.addLombokCommand("EqualsAndHashCode", EqualsAndHashCode.class);
        this.addLombokCommand("NoArgsConstructor", NoArgsConstructor.class);
        this.addLombokCommand("AllArgsConstructor", AllArgsConstructor.class);
        this.addCommand(new LombokCommand("Builder", new Class[]{Builder.class}){

            @Override
            public void editGeneratedClass(JDefinedClass generatedClass) {
                generatedClass.annotate(NoArgsConstructor.class);
                generatedClass.annotate(AllArgsConstructor.class);
                generatedClass.annotate(Builder.class).param("builderMethodName", "builderFor" + generatedClass.name());
            }
        });
        this.addCommand(new Command("removeGeneratedSourceSetters", "remove Setters from JAXB generated sources"){

            @Override
            public void editGeneratedClass(JDefinedClass generatedClass) {
                LombokPlugin.this.removeGeneratedSourceSetters(generatedClass);
            }
        });
    }

    private void addLombokCommand(String name, Class ... lombokAnnotation) {
        this.addCommand(new LombokCommand(name, lombokAnnotation));
    }

    private void addCommand(Command command) {
        this.commands.put(command.getParameter(), command);
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  -").append(OPTION_NAME).append(":  add Lombok annotations \n");
        for (Command command : this.commands.values()) {
            stringBuilder.append(command.getUsage()).append("\n");
        }
        return stringBuilder.toString();
    }

    public int parseArgument(Options opt, String[] args, int i) {
        String arg = args[i].trim();
        Command command = this.commands.get(arg);
        if (command != null) {
            command.setEnabled(true);
            return 1;
        }
        return 0;
    }

    private boolean isAbstractClass(JDefinedClass generatedClass) {
        return generatedClass.isAbstract() || generatedClass.isInterface() || generatedClass.isAnonymous();
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (ClassOutline generatedClassOutline : outline.getClasses()) {
            JDefinedClass generatedClass = generatedClassOutline.implClass;
            if (this.isAbstractClass(generatedClass) || generatedClass.fields().isEmpty()) continue;
            boolean commandExecuted = false;
            for (Command command : this.commands.values()) {
                if (!command.isEnabled()) continue;
                command.editGeneratedClass(generatedClass);
                commandExecuted = true;
            }
            if (commandExecuted) continue;
            this.defaultCommand.editGeneratedClass(generatedClass);
        }
        return true;
    }

    private void removeGeneratedSourceSetters(JDefinedClass generatedClass) {
        ArrayList<JMethod> setters = new ArrayList<JMethod>();
        for (JMethod method : generatedClass.methods()) {
            if (!method.name().startsWith("set")) continue;
            setters.add(method);
        }
        for (JMethod method : setters) {
            generatedClass.methods().remove(method);
        }
    }
}

