/*
 * Decompiled with CFR 0.152.
 */
package com.github.sviperll.tasks;

import com.github.sviperll.tasks.Task;
import com.github.sviperll.tasks.Tasks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParallelTask
implements Task {
    private final Task[] tasks;
    private volatile ThreadManager threadManager = new ThreadManager(Collections.emptyList());

    public ParallelTask(Task[] tasks) {
        this.tasks = tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Thread> threads = new ArrayList<Thread>(this.tasks.length);
        try {
            for (Task task : this.tasks) {
                threads.add(Tasks.spawn(task));
            }
        }
        finally {
            this.threadManager = new ThreadManager(threads);
            this.threadManager.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            RuntimeException exception = null;
            for (Task task : this.tasks) {
                try {
                    task.stop();
                }
                catch (RuntimeException ex) {
                    exception = ex;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            this.threadManager.interrupt();
        }
    }

    @Override
    public void close() {
        RuntimeException exception = null;
        for (Task task : this.tasks) {
            try {
                task.close();
            }
            catch (RuntimeException ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static class ThreadManager {
        private final List<Thread> threads;

        private ThreadManager(List<Thread> threads) {
            this.threads = threads;
        }

        private void join() {
            block2: for (Thread thread : this.threads) {
                while (true) {
                    try {
                        thread.join();
                        continue block2;
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
            }
        }

        private void interrupt() {
            for (Thread thread : this.threads) {
                thread.interrupt();
            }
        }
    }
}

