/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;

public final class MinimumCountRule
implements IEventBasedRule<Integer> {
    private final int minimumCount;

    public MinimumCountRule(int minimumCount) {
        if (minimumCount <= 0) {
            throw new IllegalStateException("Minimum count rule must be configured with a positive threshold");
        }
        this.minimumCount = minimumCount;
    }

    @Override
    public boolean shouldAllowFeedbackPromptByDefault() {
        return false;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull Integer cachedEventValue) {
        return cachedEventValue >= this.minimumCount;
    }

    @Override
    @NonNull
    public String getDescription() {
        return "MinimumCountRule with minimum required count of " + this.minimumCount;
    }
}

