/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.interfaces.IQuestion;
import com.github.stkent.amplify.prompt.interfaces.IQuestionPresenter;
import com.github.stkent.amplify.prompt.interfaces.IQuestionView;

@SuppressLint(value={"ViewConstructor"})
class CustomLayoutQuestionView
extends FrameLayout
implements IQuestionView {
    private static final String QUESTION_PRESENTER_MUST_BE_SET_EXCEPTION_MESSAGE = "Question presenter must be set before buttons can be clicked.";
    @NonNull
    private final TextView titleTextView;
    @Nullable
    private final TextView subtitleTextView;
    @NonNull
    private final View positiveButton;
    @NonNull
    private final View negativeButton;
    private IQuestionPresenter questionPresenter;

    CustomLayoutQuestionView(Context context, @LayoutRes int layoutRes) {
        super(context);
        LayoutInflater.from((Context)context).inflate(layoutRes, (ViewGroup)this, true);
        TextView titleTextView = (TextView)this.findViewById(R.id.amplify_title_text_view);
        View positiveButton = this.findViewById(R.id.amplify_positive_button);
        View negativeButton = this.findViewById(R.id.amplify_negative_button);
        if (titleTextView == null || positiveButton == null || negativeButton == null) {
            throw new IllegalStateException("Provided layout does not include views with required ids.");
        }
        this.titleTextView = titleTextView;
        this.subtitleTextView = (TextView)this.findViewById(R.id.amplify_subtitle_text_view);
        this.positiveButton = positiveButton;
        this.negativeButton = negativeButton;
        positiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomLayoutQuestionView.this.questionPresenter == null) {
                    throw new IllegalStateException(CustomLayoutQuestionView.QUESTION_PRESENTER_MUST_BE_SET_EXCEPTION_MESSAGE);
                }
                CustomLayoutQuestionView.this.questionPresenter.userRespondedPositively();
            }
        });
        negativeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomLayoutQuestionView.this.questionPresenter == null) {
                    throw new IllegalStateException(CustomLayoutQuestionView.QUESTION_PRESENTER_MUST_BE_SET_EXCEPTION_MESSAGE);
                }
                CustomLayoutQuestionView.this.questionPresenter.userRespondedNegatively();
            }
        });
    }

    @Override
    public void setPresenter(@NonNull IQuestionPresenter questionPresenter) {
        this.questionPresenter = questionPresenter;
    }

    @Override
    public void bind(@NonNull IQuestion question) {
        this.titleTextView.setText((CharSequence)question.getTitle());
        this.setQuoteButtonUnquoteText(this.positiveButton, question.getPositiveButtonLabel());
        this.setQuoteButtonUnquoteText(this.negativeButton, question.getNegativeButtonLabel());
        String subtitle = question.getSubTitle();
        if (this.subtitleTextView != null) {
            if (subtitle != null) {
                this.subtitleTextView.setText((CharSequence)subtitle);
                this.subtitleTextView.setVisibility(0);
            } else {
                this.subtitleTextView.setVisibility(8);
            }
        }
    }

    @NonNull
    protected TextView getTitleTextView() {
        return this.titleTextView;
    }

    @Nullable
    protected TextView getSubtitleTextView() {
        return this.subtitleTextView;
    }

    @NonNull
    protected View getPositiveButton() {
        return this.positiveButton;
    }

    @NonNull
    protected View getNegativeButton() {
        return this.negativeButton;
    }

    private void setQuoteButtonUnquoteText(@NonNull View quoteButtonUnquote, @NonNull String text) {
        if (quoteButtonUnquote instanceof TextView) {
            ((TextView)quoteButtonUnquote).setText((CharSequence)text);
        }
    }
}

