/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.feedback;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.IApp;
import com.github.stkent.amplify.IDevice;
import com.github.stkent.amplify.IEnvironment;
import com.github.stkent.amplify.feedback.IFeedbackCollector;
import com.github.stkent.amplify.utils.StringUtils;

public final class GooglePlayStoreFeedbackCollector
implements IFeedbackCollector {
    private static final String ANDROID_MARKET_URI_PREFIX = "market://details?id=";
    private static final String GOOGLE_PLAY_STORE_URI_PREFIX = "https://play.google.com/store/apps/details?id=";
    @Nullable
    private final String overridePackageName;

    public GooglePlayStoreFeedbackCollector() {
        this.overridePackageName = null;
    }

    public GooglePlayStoreFeedbackCollector(@NonNull String overridePackageName) {
        this.overridePackageName = overridePackageName;
    }

    @Override
    public boolean tryCollectingFeedback(@NonNull Activity currentActivity, @NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        String packageName = StringUtils.defaultIfBlank(this.overridePackageName, currentActivity.getPackageName());
        try {
            currentActivity.startActivity(new Intent("android.intent.action.VIEW", this.getAndroidMarketUri(packageName)));
            currentActivity.overridePendingTransition(0x10A0000, 0x10A0001);
            return true;
        }
        catch (ActivityNotFoundException ignored) {
            try {
                currentActivity.startActivity(new Intent("android.intent.action.VIEW", this.getGooglePlayStoreUri(packageName)));
                currentActivity.overridePendingTransition(0x10A0000, 0x10A0001);
                return true;
            }
            catch (ActivityNotFoundException ignored2) {
                return false;
            }
        }
    }

    @NonNull
    private Uri getAndroidMarketUri(@NonNull String packageName) {
        return Uri.parse((String)(ANDROID_MARKET_URI_PREFIX + packageName));
    }

    @NonNull
    private Uri getGooglePlayStoreUri(@NonNull String packageName) {
        return Uri.parse((String)(GOOGLE_PLAY_STORE_URI_PREFIX + packageName));
    }
}

