/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.IEnvironment;
import java.util.List;

public final class Environment
implements IEnvironment {
    @NonNull
    private final Context appContext;

    public Environment(@NonNull Context context) {
        this.appContext = context.getApplicationContext();
    }

    @Override
    @NonNull
    public String getAndroidVersionName() {
        return Build.VERSION.RELEASE;
    }

    @Override
    public int getAndroidVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public boolean isAppInstalled(@NonNull String packageName) {
        PackageManager packageManager = this.appContext.getPackageManager();
        try {
            return packageManager.getPackageInfo(packageName, 1) != null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public boolean isAmazonAppStoreInstalled() {
        return this.isAppInstalled("com.amazon.venezia");
    }

    @Override
    public boolean isGooglePlayStoreInstalled() {
        return this.isAppInstalled("com.android.vending");
    }

    @Override
    public boolean canHandleIntent(@NonNull Intent intent) {
        List resolveInfoList = this.appContext.getPackageManager().queryIntentActivities(intent, 65536);
        return !resolveInfoList.isEmpty();
    }
}

