/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.tracking.Amplify;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEventsManager;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseEventsManager<T>
implements IEventsManager<T> {
    private static final String AMPLIFY_TRACKING_KEY_PREFIX = "AMPLIFY_";
    private final ISettings<T> settings;
    private final ConcurrentHashMap<IEvent, List<IEventBasedRule<T>>> internalMap;

    @NonNull
    protected abstract String getTrackedEventDimensionDescription();

    @NonNull
    protected abstract String getEventTrackingStatusStringSuffix(@NonNull T var1);

    @NonNull
    protected abstract T getUpdatedTrackingValue(@Nullable T var1);

    protected BaseEventsManager(@NonNull ISettings<T> settings) {
        this.settings = settings;
        this.internalMap = new ConcurrentHashMap();
    }

    @Override
    public void addEventBasedRule(@NonNull IEvent event, @NonNull IEventBasedRule<T> rule) {
        if (!this.isTrackingEvent(event)) {
            this.internalMap.put(event, new ArrayList());
        }
        this.internalMap.get(event).add(rule);
        Amplify.getLogger().d("Registered " + rule.getDescription() + " for event " + event.getTrackingKey());
    }

    @Override
    public void notifyEventTriggered(@NonNull IEvent event) {
        if (this.isTrackingEvent(event)) {
            T cachedTrackingValue = this.getCachedTrackingValue(event);
            T updatedTrackingValue = this.getUpdatedTrackingValue(cachedTrackingValue);
            if (cachedTrackingValue == null) {
                Amplify.getLogger().d("Setting " + this.getTrackedEventDimensionDescription().toLowerCase(Locale.US) + " of " + event.getTrackingKey() + " event to " + updatedTrackingValue);
            } else if (!updatedTrackingValue.equals(cachedTrackingValue)) {
                Amplify.getLogger().d("Updating " + this.getTrackedEventDimensionDescription().toLowerCase(Locale.US) + " of " + event.getTrackingKey() + " event from " + cachedTrackingValue + " to " + updatedTrackingValue);
            }
            this.settings.writeTrackingValue(this.getTrackingKey(event), updatedTrackingValue);
        }
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        boolean result = true;
        for (Map.Entry<IEvent, List<IEventBasedRule<T>>> rules : this.internalMap.entrySet()) {
            IEvent event = rules.getKey();
            for (IEventBasedRule<T> rule : rules.getValue()) {
                T cachedEventValue = this.getCachedTrackingValue(event);
                if (cachedEventValue != null) {
                    Amplify.getLogger().d(event.getTrackingKey() + " event " + this.getEventTrackingStatusStringSuffix(cachedEventValue));
                    if (rule.shouldAllowFeedbackPrompt(cachedEventValue)) continue;
                    this.logPromptBlockedMessage(rule, event);
                    result = false;
                    continue;
                }
                Amplify.getLogger().d("No tracked value for " + this.getTrackedEventDimensionDescription().toLowerCase(Locale.US) + " of " + event.getTrackingKey() + " event");
                if (rule.shouldAllowFeedbackPromptByDefault()) continue;
                this.logPromptBlockedMessage(rule, event);
                result = false;
            }
        }
        return result;
    }

    private boolean isTrackingEvent(@NonNull IEvent event) {
        return this.internalMap.containsKey(event);
    }

    private String getTrackingKey(@NonNull IEvent event) {
        return AMPLIFY_TRACKING_KEY_PREFIX + event.getTrackingKey() + "_" + this.getTrackingKeySuffix().toUpperCase();
    }

    @NonNull
    private String getTrackingKeySuffix() {
        return this.getTrackedEventDimensionDescription().trim().toUpperCase(Locale.US).replaceAll("\\s+", "_");
    }

    @Nullable
    private T getCachedTrackingValue(@NonNull IEvent event) {
        return this.settings.readTrackingValue(this.getTrackingKey(event));
    }

    private void logPromptBlockedMessage(@NonNull IEventBasedRule<T> rule, @NonNull IEvent event) {
        Amplify.getLogger().d("Blocking feedback because of " + rule.getDescription() + " associated with " + event.getTrackingKey() + " event");
    }
}

