/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public abstract class InstallSource {
    @NonNull
    static InstallSource fromInstallerPackageName(@Nullable String installerPackageName) {
        if ("com.android.vending".equalsIgnoreCase(installerPackageName)) {
            return new GooglePlayStoreInstallSource();
        }
        if ("com.amazon.venezia".equalsIgnoreCase(installerPackageName)) {
            return new AmazonAppStoreInstallSource();
        }
        if ("com.amazon.mshop.android".equalsIgnoreCase(installerPackageName)) {
            return new AmazonUndergroundInstallSource();
        }
        if ("com.google.android.packageinstaller".equalsIgnoreCase(installerPackageName)) {
            return new PackageInstallerInstallSource();
        }
        if (installerPackageName != null) {
            return new UnrecognizedInstallSource(installerPackageName);
        }
        return new UnknownInstallSource();
    }

    private InstallSource() {
    }

    public static final class UnrecognizedInstallSource
    extends InstallSource {
        @NonNull
        private final String installerPackageName;

        private UnrecognizedInstallSource(@NonNull String installerPackageName) {
            this.installerPackageName = installerPackageName;
        }

        public String toString() {
            return this.installerPackageName;
        }
    }

    public static final class UnknownInstallSource
    extends InstallSource {
        public String toString() {
            return "Unknown";
        }
    }

    public static final class PackageInstallerInstallSource
    extends InstallSource {
        public String toString() {
            return "Package Installer";
        }
    }

    public static final class AmazonUndergroundInstallSource
    extends InstallSource {
        public String toString() {
            return "Amazon Underground";
        }
    }

    public static final class AmazonAppStoreInstallSource
    extends InstallSource {
        public String toString() {
            return "Amazon Appstore";
        }
    }

    public static final class GooglePlayStoreInstallSource
    extends InstallSource {
        public String toString() {
            return "Google Play Store";
        }
    }
}

