/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils.feedback;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.Amplify;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.tracking.interfaces.IFeedbackDataProvider;
import com.github.stkent.amplify.utils.feedback.IEmailContentProvider;

public final class FeedbackUtil {
    private final IFeedbackDataProvider feedbackDataProvider;
    private final IEmailContentProvider emailContentProvider;
    private final IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider;
    private final String feedbackEmailAddress;

    public FeedbackUtil(@NonNull IFeedbackDataProvider feedbackDataProvider, @NonNull IEmailContentProvider emailContentProvider, @NonNull IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider, @NonNull String feedbackEmailAddress) {
        this.feedbackDataProvider = feedbackDataProvider;
        this.emailContentProvider = emailContentProvider;
        this.environmentCapabilitiesProvider = environmentCapabilitiesProvider;
        this.feedbackEmailAddress = feedbackEmailAddress;
    }

    public void showFeedbackEmailChooser(@NonNull Activity activity) {
        Intent feedbackEmailIntent = this.getFeedbackEmailIntent();
        if (!this.environmentCapabilitiesProvider.canHandleIntent(feedbackEmailIntent)) {
            Amplify.getLogger().e("Unable to present email client chooser.");
            return;
        }
        activity.startActivity(Intent.createChooser((Intent)feedbackEmailIntent, (CharSequence)"Choose an email provider:"));
        activity.overridePendingTransition(0, 0);
    }

    @NonNull
    private Intent getFeedbackEmailIntent() {
        Intent result = new Intent("android.intent.action.SENDTO");
        result.setData(Uri.parse((String)"mailto:"));
        result.putExtra("android.intent.extra.EMAIL", new String[]{this.feedbackEmailAddress});
        result.putExtra("android.intent.extra.SUBJECT", this.emailContentProvider.getEmailSubjectLine(this.feedbackDataProvider));
        result.putExtra("android.intent.extra.TEXT", this.emailContentProvider.getInitialEmailBody(this.feedbackDataProvider));
        return result;
    }
}

