/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.prompt.interfaces.IPromptPresenter;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;
import com.github.stkent.amplify.tracking.PromptInteractionEvent;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventListener;
import java.util.ArrayList;
import java.util.List;

public final class PromptPresenter
implements IPromptPresenter {
    private static final String PROMPT_FLOW_STATE_KEY = "PromptFlowStateKey";
    private static final IPromptPresenter.PromptFlowState DEFAULT_PROMPT_FLOW_STATE = IPromptPresenter.PromptFlowState.INITIALIZED;
    @NonNull
    private final IEventListener eventListener;
    @NonNull
    private final IPromptView promptView;
    @NonNull
    private IPromptPresenter.PromptFlowState promptFlowState = DEFAULT_PROMPT_FLOW_STATE;
    @NonNull
    private final List<IEventListener> extraEventListeners = new ArrayList<IEventListener>();

    public PromptPresenter(@NonNull IEventListener eventListener, @NonNull IPromptView promptView) {
        this.eventListener = eventListener;
        this.promptView = promptView;
    }

    @Override
    public void notifyEventTriggered(@NonNull IEvent event) {
        this.eventListener.notifyEventTriggered(event);
        for (IEventListener extraEventListener : this.extraEventListeners) {
            extraEventListener.notifyEventTriggered(event);
        }
    }

    @Override
    public void addPromptEventListener(@NonNull IEventListener promptEventListener) {
        this.extraEventListeners.add(promptEventListener);
    }

    @Override
    public void start() {
        this.setToState(IPromptPresenter.PromptFlowState.QUERYING_USER_OPINION);
    }

    @Override
    public void reportUserOpinion(@NonNull IPromptPresenter.UserOpinion userOpinion) {
        if (userOpinion == IPromptPresenter.UserOpinion.POSITIVE) {
            this.notifyEventTriggered(PromptInteractionEvent.USER_INDICATED_POSITIVE_OPINION);
            this.setToState(IPromptPresenter.PromptFlowState.REQUESTING_POSITIVE_FEEDBACK);
        } else if (userOpinion == IPromptPresenter.UserOpinion.CRITICAL) {
            this.notifyEventTriggered(PromptInteractionEvent.USER_INDICATED_CRITICAL_OPINION);
            this.setToState(IPromptPresenter.PromptFlowState.REQUESTING_CRITICAL_FEEDBACK);
        }
    }

    @Override
    public void reportUserFeedbackAction(@NonNull IPromptPresenter.UserFeedbackAction userFeedbackAction) {
        if (this.promptFlowState != IPromptPresenter.PromptFlowState.REQUESTING_POSITIVE_FEEDBACK && this.promptFlowState != IPromptPresenter.PromptFlowState.REQUESTING_CRITICAL_FEEDBACK) {
            throw new IllegalStateException("User opinion must be set before this method is called.");
        }
        if (userFeedbackAction == IPromptPresenter.UserFeedbackAction.AGREED) {
            this.handleUserAgreedToGiveFeedback();
        } else if (userFeedbackAction == IPromptPresenter.UserFeedbackAction.DECLINED) {
            this.handleUserDeclinedToGiveFeedback();
        }
    }

    @Override
    public void restoreStateFromBundle(@NonNull Bundle bundle) {
        IPromptPresenter.PromptFlowState promptFlowState = IPromptPresenter.PromptFlowState.values()[bundle.getInt(PROMPT_FLOW_STATE_KEY, DEFAULT_PROMPT_FLOW_STATE.ordinal())];
        this.setToState(promptFlowState, true);
    }

    @Override
    @NonNull
    public Bundle generateStateBundle() {
        Bundle result = new Bundle();
        result.putInt(PROMPT_FLOW_STATE_KEY, this.promptFlowState.ordinal());
        return result;
    }

    private void handleUserAgreedToGiveFeedback() {
        this.notifyEventTriggered(PromptInteractionEvent.USER_GAVE_FEEDBACK);
        if (this.promptFlowState == IPromptPresenter.PromptFlowState.REQUESTING_POSITIVE_FEEDBACK) {
            this.notifyEventTriggered(PromptInteractionEvent.USER_GAVE_POSITIVE_FEEDBACK);
        } else if (this.promptFlowState == IPromptPresenter.PromptFlowState.REQUESTING_CRITICAL_FEEDBACK) {
            this.notifyEventTriggered(PromptInteractionEvent.USER_GAVE_CRITICAL_FEEDBACK);
        }
        if (this.promptView.providesThanksView()) {
            this.setToState(IPromptPresenter.PromptFlowState.THANKING_USER);
        } else {
            this.setToState(IPromptPresenter.PromptFlowState.DISMISSED);
        }
    }

    private void handleUserDeclinedToGiveFeedback() {
        this.notifyEventTriggered(PromptInteractionEvent.USER_DECLINED_FEEDBACK);
        if (this.promptFlowState == IPromptPresenter.PromptFlowState.REQUESTING_POSITIVE_FEEDBACK) {
            this.notifyEventTriggered(PromptInteractionEvent.USER_DECLINED_POSITIVE_FEEDBACK);
        } else if (this.promptFlowState == IPromptPresenter.PromptFlowState.REQUESTING_CRITICAL_FEEDBACK) {
            this.notifyEventTriggered(PromptInteractionEvent.USER_DECLINED_CRITICAL_FEEDBACK);
        }
        this.setToState(IPromptPresenter.PromptFlowState.DISMISSED);
    }

    private void setToState(@NonNull IPromptPresenter.PromptFlowState promptFlowState) {
        this.setToState(promptFlowState, false);
    }

    private void setToState(@NonNull IPromptPresenter.PromptFlowState promptFlowState, boolean triggeredByConfigChange) {
        this.promptFlowState = promptFlowState;
        switch (promptFlowState) {
            case QUERYING_USER_OPINION: {
                this.promptView.queryUserOpinion(triggeredByConfigChange);
                break;
            }
            case REQUESTING_POSITIVE_FEEDBACK: {
                this.promptView.requestPositiveFeedback();
                break;
            }
            case REQUESTING_CRITICAL_FEEDBACK: {
                this.promptView.requestCriticalFeedback();
                break;
            }
            case THANKING_USER: {
                this.promptView.thankUser(triggeredByConfigChange);
                break;
            }
            case DISMISSED: {
                this.promptView.dismiss(triggeredByConfigChange);
                break;
            }
        }
    }
}

