/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.annotation.SuppressLint;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleableRes;
import com.github.stkent.amplify.R;

public final class DefaultLayoutPromptViewConfig
implements Parcelable {
    @ColorInt
    private static final int DEFAULT_FOREGROUND_COLOR = -1;
    @ColorInt
    private static final int DEFAULT_BACKGROUND_COLOR = -12821866;
    private static final int DEFAULT_GET_COLOR_VALUE_IF_UNDEFINED = Integer.MAX_VALUE;
    private static final int DEFAULT_GET_DIMENSION_VALUE_IF_UNDEFINED = Integer.MAX_VALUE;
    @Nullable
    private final Integer foregroundColor;
    @Nullable
    private final Integer backgroundColor;
    @Nullable
    private final Integer titleTextColor;
    @Nullable
    private final Integer subtitleTextColor;
    @Nullable
    private final Integer positiveButtonTextColor;
    @Nullable
    private final Integer positiveButtonBackgroundColor;
    @Nullable
    private final Integer positiveButtonBorderColor;
    @Nullable
    private final Integer negativeButtonTextColor;
    @Nullable
    private final Integer negativeButtonBackgroundColor;
    @Nullable
    private final Integer negativeButtonBorderColor;
    @Nullable
    private final Integer customTextSizePx;
    @Nullable
    private final Integer customButtonBorderWidthPx;
    @Nullable
    private final Integer customButtonCornerRadiusPx;
    public static final Parcelable.Creator<DefaultLayoutPromptViewConfig> CREATOR = new Parcelable.Creator<DefaultLayoutPromptViewConfig>(){

        public DefaultLayoutPromptViewConfig createFromParcel(Parcel in) {
            return new DefaultLayoutPromptViewConfig(in);
        }

        public DefaultLayoutPromptViewConfig[] newArray(int size) {
            return new DefaultLayoutPromptViewConfig[size];
        }
    };

    @ColorInt
    private static int defaultIfNull(@Nullable Integer primaryColor, @ColorInt int defaultColor) {
        return primaryColor != null ? primaryColor : defaultColor;
    }

    @Nullable
    private static Integer suppliedColorOrNull(@Nullable TypedArray typedArray, @StyleableRes int index) {
        if (typedArray != null) {
            int color = typedArray.getColor(index, Integer.MAX_VALUE);
            return color != Integer.MAX_VALUE ? Integer.valueOf(color) : null;
        }
        return null;
    }

    @Nullable
    private static Integer suppliedDimensionOrNull(@Nullable TypedArray typedArray, @StyleableRes int index) {
        if (typedArray != null) {
            int dimensionPixelSize = typedArray.getDimensionPixelSize(index, Integer.MAX_VALUE);
            return dimensionPixelSize != Integer.MAX_VALUE ? Integer.valueOf(dimensionPixelSize) : null;
        }
        return null;
    }

    public DefaultLayoutPromptViewConfig(@Nullable TypedArray typedArray) {
        this.foregroundColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_foreground_color);
        this.backgroundColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_background_color);
        this.titleTextColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_title_text_color);
        this.subtitleTextColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_subtitle_text_color);
        this.positiveButtonTextColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_positive_button_text_color);
        this.positiveButtonBackgroundColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_positive_button_background_color);
        this.positiveButtonBorderColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_positive_button_border_color);
        this.negativeButtonTextColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_negative_button_text_color);
        this.negativeButtonBackgroundColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_negative_button_background_color);
        this.negativeButtonBorderColor = DefaultLayoutPromptViewConfig.suppliedColorOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_negative_button_border_color);
        this.customTextSizePx = DefaultLayoutPromptViewConfig.suppliedDimensionOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_text_size);
        this.customButtonBorderWidthPx = DefaultLayoutPromptViewConfig.suppliedDimensionOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_button_border_width);
        this.customButtonCornerRadiusPx = DefaultLayoutPromptViewConfig.suppliedDimensionOrNull(typedArray, R.styleable.DefaultLayoutPromptView_prompt_view_button_corner_radius);
    }

    protected DefaultLayoutPromptViewConfig(@Nullable Integer foregroundColor, @Nullable Integer backgroundColor, @Nullable Integer titleTextColor, @Nullable Integer subtitleTextColor, @Nullable Integer positiveButtonTextColor, @Nullable Integer positiveButtonBackgroundColor, @Nullable Integer positiveButtonBorderColor, @Nullable Integer negativeButtonTextColor, @Nullable Integer negativeButtonBackgroundColor, @Nullable Integer negativeButtonBorderColor, @Nullable Integer customTextSizePx, @Nullable Integer customButtonBorderWidthPx, @Nullable Integer customButtonCornerRadiusPx) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.titleTextColor = titleTextColor;
        this.subtitleTextColor = subtitleTextColor;
        this.positiveButtonTextColor = positiveButtonTextColor;
        this.positiveButtonBackgroundColor = positiveButtonBackgroundColor;
        this.positiveButtonBorderColor = positiveButtonBorderColor;
        this.negativeButtonTextColor = negativeButtonTextColor;
        this.negativeButtonBackgroundColor = negativeButtonBackgroundColor;
        this.negativeButtonBorderColor = negativeButtonBorderColor;
        this.customTextSizePx = customTextSizePx;
        this.customButtonBorderWidthPx = customButtonBorderWidthPx;
        this.customButtonCornerRadiusPx = customButtonCornerRadiusPx;
    }

    @ColorInt
    public int getFillColor() {
        return this.getBackgroundColor();
    }

    @ColorInt
    public int getTitleTextColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.titleTextColor, this.getForegroundColor());
    }

    @ColorInt
    public int getSubtitleTextColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.subtitleTextColor, this.getForegroundColor());
    }

    @ColorInt
    public int getPositiveButtonTextColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.positiveButtonTextColor, this.getBackgroundColor());
    }

    @ColorInt
    public int getPositiveButtonBackgroundColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.positiveButtonBackgroundColor, this.getForegroundColor());
    }

    @ColorInt
    public int getPositiveButtonBorderColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.positiveButtonBorderColor, this.getForegroundColor());
    }

    @ColorInt
    public int getNegativeButtonTextColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.negativeButtonTextColor, this.getForegroundColor());
    }

    @ColorInt
    public int getNegativeButtonBackgroundColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.negativeButtonBackgroundColor, this.getBackgroundColor());
    }

    @ColorInt
    public int getNegativeButtonBorderColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.negativeButtonBorderColor, this.getForegroundColor());
    }

    @Nullable
    public Integer getCustomTextSizePx() {
        return this.customTextSizePx;
    }

    @Nullable
    public Integer getCustomButtonBorderWidthPx() {
        return this.customButtonBorderWidthPx;
    }

    @Nullable
    public Integer getCustomButtonCornerRadiusPx() {
        return this.customButtonCornerRadiusPx;
    }

    @ColorInt
    private int getForegroundColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.foregroundColor, -1);
    }

    @ColorInt
    private int getBackgroundColor() {
        return DefaultLayoutPromptViewConfig.defaultIfNull(this.backgroundColor, -12821866);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.foregroundColor);
        dest.writeValue((Object)this.backgroundColor);
        dest.writeValue((Object)this.titleTextColor);
        dest.writeValue((Object)this.subtitleTextColor);
        dest.writeValue((Object)this.positiveButtonTextColor);
        dest.writeValue((Object)this.positiveButtonBackgroundColor);
        dest.writeValue((Object)this.positiveButtonBorderColor);
        dest.writeValue((Object)this.negativeButtonTextColor);
        dest.writeValue((Object)this.negativeButtonBackgroundColor);
        dest.writeValue((Object)this.negativeButtonBorderColor);
        dest.writeValue((Object)this.customTextSizePx);
        dest.writeValue((Object)this.customButtonBorderWidthPx);
        dest.writeValue((Object)this.customButtonCornerRadiusPx);
    }

    @SuppressLint(value={"ParcelClassLoader"})
    protected DefaultLayoutPromptViewConfig(@NonNull Parcel in) {
        this.foregroundColor = (Integer)in.readValue(null);
        this.backgroundColor = (Integer)in.readValue(null);
        this.titleTextColor = (Integer)in.readValue(null);
        this.subtitleTextColor = (Integer)in.readValue(null);
        this.positiveButtonTextColor = (Integer)in.readValue(null);
        this.positiveButtonBackgroundColor = (Integer)in.readValue(null);
        this.positiveButtonBorderColor = (Integer)in.readValue(null);
        this.negativeButtonTextColor = (Integer)in.readValue(null);
        this.negativeButtonBackgroundColor = (Integer)in.readValue(null);
        this.negativeButtonBorderColor = (Integer)in.readValue(null);
        this.customTextSizePx = (Integer)in.readValue(null);
        this.customButtonBorderWidthPx = (Integer)in.readValue(null);
        this.customButtonCornerRadiusPx = (Integer)in.readValue(null);
    }

    public static final class Builder {
        @Nullable
        private Integer foregroundColor;
        @Nullable
        private Integer backgroundColor;
        @Nullable
        private Integer titleTextColor;
        @Nullable
        private Integer subtitleTextColor;
        @Nullable
        private Integer positiveButtonTextColor;
        @Nullable
        private Integer positiveButtonBackgroundColor;
        @Nullable
        private Integer positiveButtonBorderColor;
        @Nullable
        private Integer negativeButtonTextColor;
        @Nullable
        private Integer negativeButtonBackgroundColor;
        @Nullable
        private Integer negativeButtonBorderColor;
        @Nullable
        private Integer customTextSizePx;
        @Nullable
        private Integer customButtonBorderWidthPx;
        @Nullable
        private Integer customButtonCornerRadiusPx;

        public Builder setForegroundColor(@ColorInt int foregroundColor) {
            this.foregroundColor = foregroundColor;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder setTitleTextColor(@ColorInt int titleTextColor) {
            this.titleTextColor = titleTextColor;
            return this;
        }

        public Builder setSubtitleTextColor(@ColorInt int subtitleTextColor) {
            this.subtitleTextColor = subtitleTextColor;
            return this;
        }

        public Builder setPositiveButtonTextColor(@ColorInt int positiveButtonTextColor) {
            this.positiveButtonTextColor = positiveButtonTextColor;
            return this;
        }

        public Builder setPositiveButtonBackgroundColor(@ColorInt int positiveButtonBackgroundColor) {
            this.positiveButtonBackgroundColor = positiveButtonBackgroundColor;
            return this;
        }

        public Builder setPositiveButtonBorderColor(@ColorInt int positiveButtonBorderColor) {
            this.positiveButtonBorderColor = positiveButtonBorderColor;
            return this;
        }

        public Builder setNegativeButtonTextColor(@ColorInt int negativeButtonTextColor) {
            this.negativeButtonTextColor = negativeButtonTextColor;
            return this;
        }

        public Builder setNegativeButtonBackgroundColor(@ColorInt int negativeButtonBackgroundColor) {
            this.negativeButtonBackgroundColor = negativeButtonBackgroundColor;
            return this;
        }

        public Builder setNegativeButtonBorderColor(@ColorInt int negativeButtonBorderColor) {
            this.negativeButtonBorderColor = negativeButtonBorderColor;
            return this;
        }

        public Builder setCustomTextSizePx(int customTextSizePx) {
            this.customTextSizePx = customTextSizePx;
            return this;
        }

        public Builder setButtonBorderWidthPx(int customButtonBorderWidthPx) {
            this.customButtonBorderWidthPx = customButtonBorderWidthPx;
            return this;
        }

        public Builder setButtonCornerRadiusPx(int customButtonCornerRadiusPx) {
            this.customButtonCornerRadiusPx = customButtonCornerRadiusPx;
            return this;
        }

        public DefaultLayoutPromptViewConfig build() {
            return new DefaultLayoutPromptViewConfig(this.foregroundColor, this.backgroundColor, this.titleTextColor, this.subtitleTextColor, this.positiveButtonTextColor, this.positiveButtonBackgroundColor, this.positiveButtonBorderColor, this.negativeButtonTextColor, this.negativeButtonBackgroundColor, this.negativeButtonBorderColor, this.customTextSizePx, this.customButtonBorderWidthPx, this.customButtonCornerRadiusPx);
        }
    }
}

