/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.interfaces.IThanks;
import com.github.stkent.amplify.prompt.interfaces.IThanksView;

@SuppressLint(value={"ViewConstructor"})
class CustomLayoutThanksView
extends FrameLayout
implements IThanksView {
    @NonNull
    private final TextView titleTextView;
    @Nullable
    private final TextView subtitleTextView;

    CustomLayoutThanksView(Context context, @LayoutRes int layoutRes) {
        super(context);
        LayoutInflater.from((Context)context).inflate(layoutRes, (ViewGroup)this, true);
        TextView titleTextView = (TextView)this.findViewById(R.id.amplify_title_text_view);
        if (titleTextView == null) {
            throw new IllegalStateException("Provided layout does not include views with required ids.");
        }
        this.titleTextView = titleTextView;
        this.subtitleTextView = (TextView)this.findViewById(R.id.amplify_subtitle_text_view);
    }

    @Override
    public void bind(@NonNull IThanks thanks) {
        this.titleTextView.setText((CharSequence)thanks.getTitle());
        String subtitle = thanks.getSubTitle();
        if (this.subtitleTextView != null) {
            if (subtitle != null) {
                this.subtitleTextView.setText((CharSequence)subtitle);
                this.subtitleTextView.setVisibility(0);
            } else {
                this.subtitleTextView.setVisibility(8);
            }
        }
    }

    @NonNull
    protected TextView getTitleTextView() {
        return this.titleTextView;
    }

    @Nullable
    protected TextView getSubtitleTextView() {
        return this.subtitleTextView;
    }
}

