/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.BasePromptViewConfig;
import com.github.stkent.amplify.prompt.PromptPresenter;
import com.github.stkent.amplify.prompt.interfaces.IPromptPresenter;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;
import com.github.stkent.amplify.prompt.interfaces.IQuestionPresenter;
import com.github.stkent.amplify.prompt.interfaces.IQuestionView;
import com.github.stkent.amplify.prompt.interfaces.IThanksView;
import com.github.stkent.amplify.tracking.Amplify;
import com.github.stkent.amplify.tracking.PromptViewEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventListener;

abstract class BasePromptView<T extends View, U extends View>
extends FrameLayout
implements IPromptView {
    protected static final String SUPER_STATE_KEY = "SUPER_STATE_KEY";
    private static final String THANKS_DISPLAY_TIME_EXPIRED_KEY = "THANKS_DISPLAY_TIME_EXPIRED_KEY";
    private static final String BASE_PROMPT_VIEW_CONFIG_KEY = "BASE_PROMPT_VIEW_CONFIG_KEY";
    private static final String PROMPT_PRESENTER_STATE_BUNDLE_KEY = "PROMPT_PRESENTER_STATE_BUNDLE_KEY";
    private final IQuestionPresenter userOpinionQuestionPresenter = new IQuestionPresenter(){

        @Override
        public void userRespondedPositively() {
            BasePromptView.this.promptPresenter.reportUserOpinion(IPromptPresenter.UserOpinion.POSITIVE);
        }

        @Override
        public void userRespondedNegatively() {
            BasePromptView.this.promptPresenter.reportUserOpinion(IPromptPresenter.UserOpinion.CRITICAL);
        }
    };
    private final IQuestionPresenter feedbackQuestionPresenter = new IQuestionPresenter(){

        @Override
        public void userRespondedPositively() {
            BasePromptView.this.promptPresenter.reportUserFeedbackAction(IPromptPresenter.UserFeedbackAction.AGREED);
        }

        @Override
        public void userRespondedNegatively() {
            BasePromptView.this.promptPresenter.reportUserFeedbackAction(IPromptPresenter.UserFeedbackAction.DECLINED);
        }
    };
    private IPromptPresenter promptPresenter;
    private BasePromptViewConfig basePromptViewConfig;
    private T displayedQuestionView;
    private boolean thanksDisplayTimeExpired;

    protected abstract boolean isConfigured();

    @NonNull
    protected abstract T getQuestionView();

    @Nullable
    protected abstract U getThanksView();

    BasePromptView(Context context) {
        this(context, null);
    }

    BasePromptView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    BasePromptView(Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.initializeBaseConfig(attributeSet);
        if (!this.isInEditMode()) {
            this.promptPresenter = new PromptPresenter(Amplify.getSharedInstance(), this);
        }
    }

    @CallSuper
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle result = new Bundle();
        result.putParcelable(SUPER_STATE_KEY, superState);
        result.putParcelable(BASE_PROMPT_VIEW_CONFIG_KEY, (Parcelable)this.basePromptViewConfig);
        result.putBoolean(THANKS_DISPLAY_TIME_EXPIRED_KEY, this.thanksDisplayTimeExpired);
        result.putBundle(PROMPT_PRESENTER_STATE_BUNDLE_KEY, this.promptPresenter.generateStateBundle());
        return result;
    }

    @CallSuper
    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Bundle savedState = (Bundle)state;
        if (savedState != null) {
            Parcelable superSavedState = savedState.getParcelable(SUPER_STATE_KEY);
            super.onRestoreInstanceState(superSavedState);
            BasePromptViewConfig config = (BasePromptViewConfig)savedState.getParcelable(BASE_PROMPT_VIEW_CONFIG_KEY);
            if (config != null) {
                this.applyBaseConfig(config);
            }
            this.thanksDisplayTimeExpired = savedState.getBoolean(THANKS_DISPLAY_TIME_EXPIRED_KEY);
        }
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        super.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        super.dispatchThawSelfOnly(container);
    }

    @Override
    @NonNull
    public final IPromptPresenter getPresenter() {
        return this.promptPresenter;
    }

    @Override
    public final void queryUserOpinion(boolean triggeredByConfigChange) {
        if (!this.isConfigured()) {
            throw new IllegalStateException("PromptView is not fully configured.");
        }
        if (!triggeredByConfigChange) {
            this.promptPresenter.notifyEventTriggered(PromptViewEvent.PROMPT_SHOWN);
        }
        this.displayQuestionViewIfNeeded();
        ((IQuestionView)this.displayedQuestionView).setPresenter(this.userOpinionQuestionPresenter);
        ((IQuestionView)this.displayedQuestionView).bind(this.basePromptViewConfig.getUserOpinionQuestion());
    }

    @Override
    public final void requestPositiveFeedback() {
        this.displayQuestionViewIfNeeded();
        ((IQuestionView)this.displayedQuestionView).setPresenter(this.feedbackQuestionPresenter);
        ((IQuestionView)this.displayedQuestionView).bind(this.basePromptViewConfig.getPositiveFeedbackQuestion());
    }

    @Override
    public final void requestCriticalFeedback() {
        this.displayQuestionViewIfNeeded();
        ((IQuestionView)this.displayedQuestionView).setPresenter(this.feedbackQuestionPresenter);
        ((IQuestionView)this.displayedQuestionView).bind(this.basePromptViewConfig.getCriticalFeedbackQuestion());
    }

    @Override
    public final void thankUser(boolean triggeredByConfigChange) {
        if (!triggeredByConfigChange) {
            this.promptPresenter.notifyEventTriggered(PromptViewEvent.THANKS_SHOWN);
        }
        this.clearDisplayedQuestionViewReference();
        if (!this.thanksDisplayTimeExpired) {
            U thanksView = this.getThanksView();
            ((IThanksView)thanksView).bind(this.basePromptViewConfig.getThanks());
            this.setDisplayedView((View)thanksView);
            Long thanksDisplayTimeMs = this.basePromptViewConfig.getThanksDisplayTimeMs();
            if (thanksDisplayTimeMs != null) {
                this.postDelayed(new Runnable((View)thanksView){
                    final /* synthetic */ View val$thanksView;
                    {
                        this.val$thanksView = view;
                    }

                    @Override
                    public void run() {
                        BasePromptView.this.thanksDisplayTimeExpired = true;
                        int fadeDurationMs = BasePromptView.this.getResources().getInteger(0x10E0001);
                        this.val$thanksView.animate().setDuration((long)fadeDurationMs).alpha(0.0f).setListener(new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                BasePromptView.this.hide();
                                BasePromptView.this.promptPresenter.notifyEventTriggered(PromptViewEvent.PROMPT_DISMISSED);
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        }).start();
                    }
                }, thanksDisplayTimeMs);
            }
        } else {
            this.hide();
        }
    }

    @Override
    public final void dismiss(boolean triggeredByConfigChange) {
        if (!triggeredByConfigChange) {
            this.promptPresenter.notifyEventTriggered(PromptViewEvent.PROMPT_DISMISSED);
        }
        this.clearDisplayedQuestionViewReference();
        this.hide();
    }

    @Override
    public final boolean providesThanksView() {
        return this.getThanksView() != null;
    }

    public final void applyBaseConfig(@NonNull BasePromptViewConfig basePromptViewConfig) {
        if (this.isDisplayed()) {
            throw new IllegalStateException("Configuration cannot be changed after the prompt is first displayed.");
        }
        this.basePromptViewConfig = basePromptViewConfig;
    }

    public final void addPromptEventListener(@NonNull IEventListener promptEventListener) {
        this.promptPresenter.addPromptEventListener(promptEventListener);
    }

    protected final void restorePresenterState(@Nullable Parcelable state) {
        Bundle promptPresenterState;
        Bundle bundle = (Bundle)state;
        if (bundle != null && (promptPresenterState = bundle.getBundle(PROMPT_PRESENTER_STATE_BUNDLE_KEY)) != null) {
            this.promptPresenter.restoreStateFromBundle(promptPresenterState);
        }
    }

    protected final boolean isDisplayed() {
        return this.getChildCount() > 0;
    }

    private void initializeBaseConfig(@Nullable AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.BasePromptView, 0, 0);
        this.basePromptViewConfig = new BasePromptViewConfig(typedArray);
        typedArray.recycle();
    }

    private void setDisplayedView(@NonNull View view) {
        this.removeAllViews();
        this.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.setVisibility(0);
    }

    private void displayQuestionViewIfNeeded() {
        if (this.displayedQuestionView == null) {
            T questionViewToDisplay = this.getQuestionView();
            this.displayedQuestionView = questionViewToDisplay;
            this.setDisplayedView((View)questionViewToDisplay);
        }
    }

    private void clearDisplayedQuestionViewReference() {
        this.displayedQuestionView = null;
    }

    private void hide() {
        this.removeAllViews();
        this.setVisibility(8);
    }
}

