/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TextView;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.CustomLayoutQuestionView;
import com.github.stkent.amplify.prompt.DefaultLayoutPromptViewConfig;
import com.github.stkent.amplify.utils.DisplayUtils;

@SuppressLint(value={"ViewConstructor"})
final class DefaultLayoutQuestionView
extends CustomLayoutQuestionView {
    private static final int NUMBER_OF_COLOR_DIMENSIONS = 3;
    private static final int DEFAULT_BUTTON_BORDER_WIDTH_DP = 1;
    private static final int DEFAULT_BUTTON_CORNER_RADIUS_PX = 0;

    DefaultLayoutQuestionView(Context context, @NonNull DefaultLayoutPromptViewConfig config) {
        super(context, R.layout.default_question_view);
        TextView subtitleTextView = this.getSubtitleTextView();
        if (subtitleTextView == null) {
            throw new IllegalStateException("Provided layout does not include views with required ids.");
        }
        this.setBackgroundColor(config.getFillColor());
        this.getTitleTextView().setTextColor(config.getTitleTextColor());
        subtitleTextView.setTextColor(config.getSubtitleTextColor());
        this.setQuoteButtonUnquoteTextColor(this.getPositiveButton(), config.getPositiveButtonTextColor());
        this.setQuoteButtonUnquoteTextColor(this.getNegativeButton(), config.getNegativeButtonTextColor());
        this.configureTextSizes(config);
        this.configureButtonBackgrounds(context, config);
    }

    private void setQuoteButtonUnquoteTextColor(@NonNull View quoteButtonUnquote, @ColorInt int color) {
        if (quoteButtonUnquote instanceof TextView) {
            ((TextView)quoteButtonUnquote).setTextColor(color);
        }
    }

    private void configureTextSizes(@NonNull DefaultLayoutPromptViewConfig config) {
        Integer customTextSizePx = config.getCustomTextSizePx();
        if (customTextSizePx != null) {
            this.getTitleTextView().setTextSize(0, (float)customTextSizePx.intValue());
            this.setQuoteButtonUnquoteTextSize(this.getPositiveButton(), customTextSizePx);
            this.setQuoteButtonUnquoteTextSize(this.getNegativeButton(), customTextSizePx);
            TextView subtitleTextView = this.getSubtitleTextView();
            if (subtitleTextView != null) {
                subtitleTextView.setTextSize(0, (float)customTextSizePx.intValue());
            }
        }
    }

    private void setQuoteButtonUnquoteTextSize(@NonNull View quoteButtonUnquote, @ColorInt int textSize) {
        if (quoteButtonUnquote instanceof TextView) {
            ((TextView)quoteButtonUnquote).setTextSize(0, (float)textSize);
        }
    }

    private void configureButtonBackgrounds(Context context, @NonNull DefaultLayoutPromptViewConfig config) {
        Integer customButtonBorderWidthPx = config.getCustomButtonBorderWidthPx();
        Integer customButtonCornerRadiusPx = config.getCustomButtonCornerRadiusPx();
        Integer actualButtonBorderWidthPx = this.customDimensionOrDefault(customButtonBorderWidthPx, DisplayUtils.dpToPx(context, 1));
        Integer actualButtonCornerRadiusPx = this.customDimensionOrDefault(customButtonCornerRadiusPx, 0);
        this.setButtonViewBackground(this.getPositiveButton(), config.getPositiveButtonBackgroundColor(), config.getPositiveButtonBorderColor(), actualButtonBorderWidthPx, actualButtonCornerRadiusPx);
        this.setButtonViewBackground(this.getNegativeButton(), config.getNegativeButtonBackgroundColor(), config.getNegativeButtonBorderColor(), actualButtonBorderWidthPx, actualButtonCornerRadiusPx);
    }

    private int customDimensionOrDefault(@Nullable Integer customDimension, int defaultDimension) {
        return customDimension != null ? customDimension : defaultDimension;
    }

    private void setButtonViewBackground(@NonNull View button, @ColorInt int fillColor, @ColorInt int borderColor, int borderWidthPx, int cornerRadiusPx) {
        Drawable buttonBackgroundDrawable = this.getButtonBackgroundDrawable(fillColor, borderColor, borderWidthPx, cornerRadiusPx);
        if (Build.VERSION.SDK_INT >= 16) {
            button.setBackground(buttonBackgroundDrawable);
        } else {
            button.setBackgroundDrawable(buttonBackgroundDrawable);
        }
    }

    @NonNull
    private Drawable getButtonBackgroundDrawable(@ColorInt int fillColor, @ColorInt int borderColor, int borderWidthPx, int cornerRadiusPx) {
        Drawable defaultDrawable = this.getStaticButtonBackgroundDrawable(fillColor, borderColor, borderWidthPx, cornerRadiusPx);
        float[] defaultFillColorHSVValues = new float[3];
        Color.colorToHSV((int)fillColor, (float[])defaultFillColorHSVValues);
        int pressedFillColor = Color.HSVToColor((int)Color.alpha((int)fillColor), (float[])new float[]{defaultFillColorHSVValues[0], defaultFillColorHSVValues[1], Math.max(defaultFillColorHSVValues[2] - 0.1f, 0.0f)});
        Drawable pressedDrawable = this.getStaticButtonBackgroundDrawable(pressedFillColor, borderColor, borderWidthPx, cornerRadiusPx);
        StateListDrawable result = new StateListDrawable();
        result.addState(new int[]{16842919}, pressedDrawable);
        result.addState(new int[]{16842910}, defaultDrawable);
        return result;
    }

    @NonNull
    private Drawable getStaticButtonBackgroundDrawable(@ColorInt int fillColor, @ColorInt int borderColor, int borderWidthPx, int cornerRadiusPx) {
        ShapeDrawable borderDrawable = new ShapeDrawable((Shape)this.getRoundRectShapeWithOuterCornerRadiusPx(cornerRadiusPx));
        borderDrawable.getPaint().setColor(borderColor);
        ShapeDrawable fillDrawable = new ShapeDrawable((Shape)this.getRoundRectShapeWithOuterCornerRadiusPx(cornerRadiusPx - borderWidthPx));
        fillDrawable.getPaint().setColor(fillColor);
        LayerDrawable result = new LayerDrawable(new Drawable[]{borderDrawable, fillDrawable});
        result.setLayerInset(1, borderWidthPx, borderWidthPx, borderWidthPx, borderWidthPx);
        return result;
    }

    @NonNull
    private RoundRectShape getRoundRectShapeWithOuterCornerRadiusPx(int rPx) {
        return new RoundRectShape(new float[]{rPx, rPx, rPx, rPx, rPx, rPx, rPx, rPx}, null, null);
    }
}

