/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils.appinfo;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.utils.appinfo.IAppInfoProvider;
import com.github.stkent.amplify.utils.appinfo.RealAppInfoProvider;

public final class AppInfoUtil {
    private static final Object SYNC_LOCK = new Object();
    @Nullable
    private static IAppInfoProvider sharedAppInfoProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(@NonNull Context context) {
        Object object = SYNC_LOCK;
        synchronized (object) {
            if (sharedAppInfoProvider == null) {
                sharedAppInfoProvider = new RealAppInfoProvider(context);
            }
        }
    }

    @NonNull
    public static IAppInfoProvider getSharedAppInfoProvider() {
        if (sharedAppInfoProvider == null) {
            throw new IllegalStateException("Must initialize AppInfoUtil before calling getSharedAppInfoProvider.");
        }
        return sharedAppInfoProvider;
    }

    public static void setSharedAppInfoProvider(@NonNull IAppInfoProvider appInfoProvider) {
        sharedAppInfoProvider = appInfoProvider;
    }

    private AppInfoUtil() {
    }
}

