/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public final class CooldownDaysRule
implements IEventBasedRule<Long> {
    private final long cooldownPeriodDays;

    public CooldownDaysRule(long cooldownPeriodDays) {
        this.cooldownPeriodDays = cooldownPeriodDays;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull Long cachedEventValue) {
        return cachedEventValue == Long.MAX_VALUE || SystemTimeUtil.currentTimeMillis() - cachedEventValue >= TimeUnit.DAYS.toMillis(this.cooldownPeriodDays);
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull Long cachedEventValue) {
        Long daysSinceLastEvent = TimeUnit.MILLISECONDS.toDays(SystemTimeUtil.currentTimeMillis() - cachedEventValue);
        return "Cooldown period: " + this.cooldownPeriodDays + " days. Time since last event: " + daysSinceLastEvent + " days.";
    }
}

