/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.Logger;
import com.github.stkent.amplify.prompt.PromptPresenter;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;
import com.github.stkent.amplify.tracking.AppEventTimeProvider;
import com.github.stkent.amplify.tracking.AppFeedbackDataProvider;
import com.github.stkent.amplify.tracking.EnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.tracking.PromptViewEvent;
import com.github.stkent.amplify.tracking.interfaces.IAppInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.IAppLevelEventRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEventListener;
import com.github.stkent.amplify.tracking.managers.AppLevelEventRulesManager;
import com.github.stkent.amplify.tracking.managers.EnvironmentBasedRulesManager;
import com.github.stkent.amplify.tracking.managers.FirstEventTimeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventTimeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventVersionRulesManager;
import com.github.stkent.amplify.tracking.managers.TotalEventCountRulesManager;
import com.github.stkent.amplify.tracking.prerequisites.GooglePlayStoreRule;
import com.github.stkent.amplify.tracking.rules.MaximumCountRule;
import com.github.stkent.amplify.tracking.rules.VersionChangedRule;
import com.github.stkent.amplify.utils.ActivityStateUtil;
import com.github.stkent.amplify.utils.AppInfoProvider;
import com.github.stkent.amplify.utils.FeedbackUtil;
import com.github.stkent.amplify.utils.PlayStoreUtil;

public final class Amplify
implements IEventListener {
    private static final int DEFAULT_USER_GAVE_POSITIVE_FEEDBACK_MAXIMUM_COUNT = 1;
    private static final int DEFAULT_LAST_UPDATE_TIME_COOLDOWN_DAYS = 7;
    private static final int DEFAULT_LAST_CRASH_TIME_COOLDOWN_DAYS = 7;
    private static Amplify sharedInstance;
    private final IAppLevelEventRulesManager appLevelEventRulesManager;
    private final IEnvironmentBasedRulesManager environmentBasedRulesManager;
    private final FirstEventTimeRulesManager firstEventTimeRulesManager;
    private final LastEventTimeRulesManager lastEventTimeRulesManager;
    private final LastEventVersionRulesManager lastEventVersionRulesManager;
    private final TotalEventCountRulesManager totalEventCountRulesManager;
    private final ILogger logger;
    private boolean alwaysShow;
    private String packageName;
    private String feedbackEmailAddress;

    public static Amplify get(@NonNull Context context) {
        return Amplify.get(context, new Logger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Amplify get(@NonNull Context context, @NonNull ILogger logger) {
        Class<Amplify> clazz = Amplify.class;
        synchronized (Amplify.class) {
            if (sharedInstance == null) {
                sharedInstance = new Amplify(context, logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private Amplify(@NonNull Context context, @NonNull ILogger logger) {
        AppInfoProvider.initialize(context);
        AppInfoProvider appInfoProvider = AppInfoProvider.getSharedInstance();
        Context appContext = context.getApplicationContext();
        AppEventTimeProvider appEventTimeProvider = new AppEventTimeProvider(appInfoProvider);
        EnvironmentCapabilitiesProvider environmentCapabilitiesProvider = new EnvironmentCapabilitiesProvider(appInfoProvider);
        this.appLevelEventRulesManager = new AppLevelEventRulesManager(appContext, appEventTimeProvider, logger);
        this.environmentBasedRulesManager = new EnvironmentBasedRulesManager(environmentCapabilitiesProvider, logger);
        this.firstEventTimeRulesManager = new FirstEventTimeRulesManager(appContext, logger);
        this.lastEventTimeRulesManager = new LastEventTimeRulesManager(appContext, logger);
        this.lastEventVersionRulesManager = new LastEventVersionRulesManager(appContext, (IAppInfoProvider)appInfoProvider, logger);
        this.totalEventCountRulesManager = new TotalEventCountRulesManager(appContext, logger);
        this.logger = logger;
    }

    public Amplify setFeedbackEmailAddress(@NonNull String feedbackEmailAddress) {
        this.feedbackEmailAddress = feedbackEmailAddress;
        return this;
    }

    public Amplify applyAllDefaultRules() {
        return this.addEnvironmentBasedRule(new GooglePlayStoreRule()).setLastUpdateTimeCooldownDays(7).setLastCrashTimeCooldownDays(7).addTotalEventCountRule(PromptViewEvent.USER_GAVE_POSITIVE_FEEDBACK, new MaximumCountRule(1)).addLastEventVersionRule(PromptViewEvent.USER_GAVE_CRITICAL_FEEDBACK, new VersionChangedRule()).addLastEventVersionRule(PromptViewEvent.USER_DECLINED_CRITICAL_FEEDBACK, new VersionChangedRule()).addLastEventVersionRule(PromptViewEvent.USER_DECLINED_POSITIVE_FEEDBACK, new VersionChangedRule());
    }

    public Amplify addEnvironmentBasedRule(@NonNull IEnvironmentBasedRule rule) {
        this.environmentBasedRulesManager.addEnvironmentBasedRule(rule);
        return this;
    }

    public Amplify setInstallTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setInstallTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify setLastUpdateTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setLastUpdateTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify setLastCrashTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setLastCrashTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify addTotalEventCountRule(@NonNull IEvent event, @NonNull IEventBasedRule<Integer> rule) {
        this.totalEventCountRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addFirstEventTimeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Long> rule) {
        this.firstEventTimeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventTimeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Long> rule) {
        this.lastEventTimeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventVersionRule(@NonNull IEvent event, @NonNull IEventBasedRule<String> rule) {
        this.lastEventVersionRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify setLogLevel(@NonNull Logger.LogLevel logLevel) {
        this.logger.setLogLevel(logLevel);
        return this;
    }

    public Amplify setAlwaysShow(boolean alwaysShow) {
        this.alwaysShow = alwaysShow;
        return this;
    }

    public Amplify setPackageName(@NonNull String packageName) {
        this.packageName = packageName;
        return this;
    }

    public void notifyEventTriggered(@NonNull IEvent event) {
        this.logger.d("Triggered Event: " + event);
        this.totalEventCountRulesManager.notifyEventTriggered(event);
        this.firstEventTimeRulesManager.notifyEventTriggered(event);
        this.lastEventTimeRulesManager.notifyEventTriggered(event);
        this.lastEventVersionRulesManager.notifyEventTriggered(event);
    }

    public void promptIfReady(@NonNull Activity activity, @NonNull IPromptView promptView) {
        this.promptIfReady(activity, promptView, null);
    }

    public void promptIfReady(final @NonNull Activity activity, @NonNull IPromptView promptView, final @Nullable IEventListener<PromptViewEvent> promptViewEventListener) {
        if (this.feedbackEmailAddress == null) {
            throw new IllegalStateException("Must provide email address before attempting to prompt.");
        }
        IEventListener<PromptViewEvent> combinedEventListener = new IEventListener<PromptViewEvent>(){

            @Override
            public void notifyEventTriggered(@NonNull PromptViewEvent event) {
                Amplify.this.notifyEventTriggered(event);
                if (promptViewEventListener != null) {
                    promptViewEventListener.notifyEventTriggered(event);
                }
                if (ActivityStateUtil.isActivityValid(activity)) {
                    if (event == PromptViewEvent.USER_GAVE_POSITIVE_FEEDBACK) {
                        PlayStoreUtil.openPlayStoreToRate(activity, Amplify.this.packageName);
                    } else if (event == PromptViewEvent.USER_GAVE_CRITICAL_FEEDBACK) {
                        AppInfoProvider appInfoProvider = AppInfoProvider.getSharedInstance();
                        FeedbackUtil feedbackUtil = new FeedbackUtil(new AppFeedbackDataProvider(appInfoProvider), new EnvironmentCapabilitiesProvider(appInfoProvider), Amplify.this.feedbackEmailAddress, Amplify.this.logger);
                        feedbackUtil.showFeedbackEmailChooser(activity);
                    }
                }
            }
        };
        if (this.shouldPrompt()) {
            PromptPresenter promptPresenter = new PromptPresenter(combinedEventListener, promptView);
            promptPresenter.start();
        }
    }

    public boolean shouldPrompt() {
        return this.alwaysShow | this.appLevelEventRulesManager.shouldAllowFeedbackPrompt() & this.environmentBasedRulesManager.shouldAllowFeedbackPrompt() & this.totalEventCountRulesManager.shouldAllowFeedbackPrompt() & this.firstEventTimeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventTimeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventVersionRulesManager.shouldAllowFeedbackPrompt();
    }
}

