/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.prompt.interfaces.IPromptPresenter;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;
import com.github.stkent.amplify.tracking.PromptViewEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventListener;

public final class PromptPresenter
implements IPromptPresenter {
    private static final String USER_OPINION_EXCEPTION_MESSAGE = "User opinion must be specified before this method is called.";
    @NonNull
    private final IEventListener<PromptViewEvent> eventListener;
    @NonNull
    private final IPromptView promptView;
    @Nullable
    private IPromptPresenter.UserOpinion userOpinion;

    public PromptPresenter(@NonNull IEventListener<PromptViewEvent> eventListener, @NonNull IPromptView promptView) {
        this.eventListener = eventListener;
        this.promptView = promptView;
        promptView.setPresenter(this);
    }

    @Override
    public void start() {
        this.promptView.queryUserOpinion();
        this.eventListener.notifyEventTriggered(PromptViewEvent.PROMPT_SHOWN);
    }

    @Override
    public void setUserOpinion(@NonNull IPromptPresenter.UserOpinion userOpinion) {
        this.userOpinion = userOpinion;
        switch (userOpinion) {
            case POSITIVE: {
                this.promptView.requestPositiveFeedback();
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_INDICATED_POSITIVE_OPINION);
                break;
            }
            case NEGATIVE: {
                this.promptView.requestCriticalFeedback();
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_INDICATED_CRITICAL_OPINION);
                break;
            }
            default: {
                throw new IllegalStateException("This switch statement should be exhaustive.");
            }
        }
    }

    @Override
    public void userAgreedToGiveFeedback() {
        if (this.userOpinion == null) {
            throw new IllegalStateException(USER_OPINION_EXCEPTION_MESSAGE);
        }
        switch (this.userOpinion) {
            case POSITIVE: {
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_GAVE_POSITIVE_FEEDBACK);
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_GAVE_FEEDBACK);
                break;
            }
            case NEGATIVE: {
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_GAVE_CRITICAL_FEEDBACK);
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_GAVE_FEEDBACK);
                break;
            }
            default: {
                throw new IllegalStateException("This switch statement should be exhaustive.");
            }
        }
        if (this.promptView.providesThanksView()) {
            this.promptView.thankUser();
            this.eventListener.notifyEventTriggered(PromptViewEvent.THANKS_SHOWN);
        } else {
            this.promptView.dismiss();
            this.eventListener.notifyEventTriggered(PromptViewEvent.PROMPT_DISMISSED);
        }
    }

    @Override
    public void userDeclinedToGiveFeedback() {
        if (this.userOpinion == null) {
            throw new IllegalStateException(USER_OPINION_EXCEPTION_MESSAGE);
        }
        switch (this.userOpinion) {
            case POSITIVE: {
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_DECLINED_POSITIVE_FEEDBACK);
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_DECLINED_FEEDBACK);
                break;
            }
            case NEGATIVE: {
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_DECLINED_CRITICAL_FEEDBACK);
                this.eventListener.notifyEventTriggered(PromptViewEvent.USER_DECLINED_FEEDBACK);
                break;
            }
            default: {
                throw new IllegalStateException("This switch statement should be exhaustive.");
            }
        }
        this.promptView.dismiss();
        this.eventListener.notifyEventTriggered(PromptViewEvent.PROMPT_DISMISSED);
    }
}

