/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.TextView;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.CustomLayoutQuestionView;
import com.github.stkent.amplify.prompt.DefaultLayoutPromptViewConfig;
import com.github.stkent.amplify.utils.DisplayUtils;

@SuppressLint(value={"ViewConstructor"})
final class DefaultLayoutQuestionView
extends CustomLayoutQuestionView {
    private static final int NUMBER_OF_COLOR_DIMENSIONS = 3;

    DefaultLayoutQuestionView(Context context, @NonNull DefaultLayoutPromptViewConfig config) {
        super(context, R.layout.default_question_view);
        this.setBackgroundColor(config.getFillColor());
        this.getTitleTextView().setTextColor(config.getTitleTextColor());
        if (this.getSubtitleTextView() != null) {
            this.getSubtitleTextView().setTextColor(config.getSubtitleTextColor());
        }
        this.setButtonViewBackground(this.getPositiveButton(), config.getPositiveButtonBackgroundColor(), config.getPositiveButtonBorderColor());
        this.setButtonViewBackground(this.getNegativeButton(), config.getNegativeButtonBackgroundColor(), config.getNegativeButtonBorderColor());
        this.setQuoteButtonUnquoteTextColor(this.getPositiveButton(), config.getPositiveButtonTextColor());
        this.setQuoteButtonUnquoteTextColor(this.getNegativeButton(), config.getNegativeButtonTextColor());
    }

    private void setQuoteButtonUnquoteTextColor(@NonNull View quoteButtonUnquote, @ColorInt int color) {
        if (quoteButtonUnquote instanceof TextView) {
            ((TextView)quoteButtonUnquote).setTextColor(color);
        }
    }

    private void setButtonViewBackground(@NonNull View button, @ColorInt int fillColor, @ColorInt int borderColor) {
        Drawable buttonBackgroundDrawable = this.getButtonBackgroundDrawable(fillColor, borderColor);
        if (Build.VERSION.SDK_INT >= 16) {
            button.setBackground(buttonBackgroundDrawable);
        } else {
            button.setBackgroundDrawable(buttonBackgroundDrawable);
        }
    }

    @NonNull
    private Drawable getButtonBackgroundDrawable(@ColorInt int fillColor, @ColorInt int borderColor) {
        Drawable defaultDrawable = this.getStaticButtonBackgroundDrawable(fillColor, borderColor);
        float[] defaultFillColorHSVValues = new float[3];
        Color.colorToHSV((int)fillColor, (float[])defaultFillColorHSVValues);
        int pressedFillColor = Color.HSVToColor((int)Color.alpha((int)fillColor), (float[])new float[]{defaultFillColorHSVValues[0], defaultFillColorHSVValues[1], Math.max(defaultFillColorHSVValues[2] - 0.1f, 0.0f)});
        Drawable pressedDrawable = this.getStaticButtonBackgroundDrawable(pressedFillColor, borderColor);
        StateListDrawable result = new StateListDrawable();
        result.addState(new int[]{16842919}, pressedDrawable);
        result.addState(new int[]{16842910}, defaultDrawable);
        return result;
    }

    @NonNull
    private Drawable getStaticButtonBackgroundDrawable(@ColorInt int fillColor, @ColorInt int borderColor) {
        ShapeDrawable borderDrawable = new ShapeDrawable((Shape)new RectShape());
        borderDrawable.getPaint().setColor(borderColor);
        ShapeDrawable fillDrawable = new ShapeDrawable((Shape)new RectShape());
        fillDrawable.getPaint().setColor(fillColor);
        LayerDrawable result = new LayerDrawable(new Drawable[]{borderDrawable, fillDrawable});
        int borderWidthPx = (int)Math.floor(DisplayUtils.dpToPx(this.getContext(), 1.0f));
        result.setLayerInset(1, borderWidthPx, borderWidthPx, borderWidthPx, borderWidthPx);
        return result;
    }
}

