/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.views;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.tracking.AmplifyViewEvent;
import com.github.stkent.amplify.tracking.ApplicationFeedbackDataProvider;
import com.github.stkent.amplify.tracking.EnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.tracking.interfaces.IAmplifyStateTracker;
import com.github.stkent.amplify.utils.FeedbackUtil;
import com.github.stkent.amplify.utils.PlayStoreUtil;
import com.github.stkent.amplify.utils.StringUtils;
import com.github.stkent.amplify.views.DefaultQuestionView;
import com.github.stkent.amplify.views.QuestionView;

public class AmplifyView
extends FrameLayout {
    private static final FrameLayout.LayoutParams CONTENT_VIEW_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-1, -1);
    @Nullable
    private IAmplifyStateTracker amplifyStateTracker;
    @Nullable
    private ILogger logger;
    private LayoutState layoutState;
    private UserOpinion userOpinion = UserOpinion.UNKNOWN;
    private String userOpinionQuestion;
    private String userOpinionTitle;
    private String positiveFeedbackQuestion;
    private String positiveFeedbackTitle;
    private String criticalFeedbackQuestion;
    private String criticalFeedbackTitle;
    private String packageName;
    private String feedbackEmail;
    @LayoutRes
    private int questionLayoutResId;
    @LayoutRes
    private int confirmationLayoutResId;
    @Nullable
    private QuestionView cachedQuestionView;
    @Nullable
    private View cachedConfirmationView;
    private final View.OnClickListener positiveButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            AmplifyView.this.checkDependenciesHaveBeenInjected();
            switch (AmplifyView.this.userOpinion) {
                case UNKNOWN: {
                    AmplifyView.this.userOpinion = UserOpinion.POSITIVE;
                    AmplifyView.this.askSecondQuestion();
                    break;
                }
                case POSITIVE: {
                    AmplifyView.this.amplifyStateTracker.notifyEventTriggered(AmplifyViewEvent.USER_GAVE_POSITIVE_FEEDBACK);
                    AmplifyView.this.thankUser();
                    AmplifyView.this.respondToPositiveFeedback();
                    break;
                }
                case NEGATIVE: {
                    AmplifyView.this.amplifyStateTracker.notifyEventTriggered(AmplifyViewEvent.USER_GAVE_CRITICAL_FEEDBACK);
                    AmplifyView.this.thankUser();
                    AmplifyView.this.respondToNegativeFeedback();
                    break;
                }
            }
        }
    };
    private final View.OnClickListener negativeButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            AmplifyView.this.checkDependenciesHaveBeenInjected();
            switch (AmplifyView.this.userOpinion) {
                case UNKNOWN: {
                    AmplifyView.this.userOpinion = UserOpinion.NEGATIVE;
                    AmplifyView.this.askSecondQuestion();
                    break;
                }
                case POSITIVE: {
                    AmplifyView.this.hide();
                    AmplifyView.this.amplifyStateTracker.notifyEventTriggered(AmplifyViewEvent.USER_DECLINED_POSITIVE_FEEDBACK);
                    break;
                }
                case NEGATIVE: {
                    AmplifyView.this.hide();
                    AmplifyView.this.amplifyStateTracker.notifyEventTriggered(AmplifyViewEvent.USER_DECLINED_CRITICAL_FEEDBACK);
                    break;
                }
            }
        }
    };

    public AmplifyView(Context context) {
        this(context, null);
    }

    public AmplifyView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AmplifyView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void injectDependencies(@NonNull IAmplifyStateTracker amplifyStateTracker, @NonNull ILogger logger, @NonNull String packageName, @NonNull String feedbackEmail) {
        this.amplifyStateTracker = amplifyStateTracker;
        this.logger = logger;
        this.packageName = packageName;
        this.feedbackEmail = feedbackEmail;
    }

    protected void respondToNegativeFeedback() {
        this.checkDependenciesHaveBeenInjected();
        Context applicationContext = this.getContext().getApplicationContext();
        FeedbackUtil feedbackUtil = new FeedbackUtil(new ApplicationFeedbackDataProvider(applicationContext), new EnvironmentCapabilitiesProvider(applicationContext), this.feedbackEmail, this.logger);
        if (this.getContext() instanceof Activity) {
            feedbackUtil.showFeedbackEmailChooser((Activity)this.getContext());
        }
    }

    protected void respondToPositiveFeedback() {
        PlayStoreUtil.openPlayStoreToRate((Activity)this.getContext(), this.packageName);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.hide();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AmplifyView, 0, 0);
        this.questionLayoutResId = typedArray.getResourceId(R.styleable.AmplifyView_amplify_question_layout, 0);
        this.confirmationLayoutResId = typedArray.getResourceId(R.styleable.AmplifyView_amplify_confirmation_layout, 0);
        this.userOpinionQuestion = StringUtils.defaultIfBlank(typedArray.getString(R.styleable.AmplifyView_amplify_user_opinion_question), "");
        this.userOpinionTitle = StringUtils.defaultIfBlank(typedArray.getString(R.styleable.AmplifyView_amplify_user_opinion_title), "");
        this.positiveFeedbackQuestion = StringUtils.defaultIfBlank(typedArray.getString(R.styleable.AmplifyView_amplify_positive_feedback_question), "");
        this.positiveFeedbackTitle = StringUtils.defaultIfBlank(typedArray.getString(R.styleable.AmplifyView_amplify_positive_feedback_title), "");
        this.criticalFeedbackQuestion = StringUtils.defaultIfBlank(typedArray.getString(R.styleable.AmplifyView_amplify_critical_feedback_question), "");
        this.criticalFeedbackTitle = StringUtils.defaultIfBlank(typedArray.getString(R.styleable.AmplifyView_amplify_critical_feedback_title), "");
        typedArray.recycle();
        this.askFirstQuestion();
    }

    private void askFirstQuestion() {
        this.setContentLayoutForNewState(LayoutState.QUESTION);
        if (this.cachedQuestionView != null) {
            this.cachedQuestionView.setQuestion(this.userOpinionQuestion);
            this.cachedQuestionView.setTitle(this.userOpinionTitle);
        }
    }

    private void askSecondQuestion() {
        this.setContentLayoutForNewState(LayoutState.QUESTION);
        if (this.cachedQuestionView != null) {
            if (this.userOpinion == UserOpinion.POSITIVE) {
                this.cachedQuestionView.setQuestion(this.positiveFeedbackQuestion);
                this.cachedQuestionView.setTitle(this.positiveFeedbackTitle);
            } else if (this.userOpinion == UserOpinion.NEGATIVE) {
                this.cachedQuestionView.setQuestion(this.criticalFeedbackQuestion);
                this.cachedQuestionView.setTitle(this.criticalFeedbackTitle);
            }
        }
    }

    private void thankUser() {
        this.setContentLayoutForNewState(LayoutState.CONFIRMATION);
    }

    private void setContentLayoutForNewState(@NonNull LayoutState newLayoutState) {
        switch (newLayoutState) {
            case QUESTION: {
                if (this.layoutState == LayoutState.QUESTION) break;
                this.removeAllViews();
                this.addQuestionView();
                break;
            }
            case CONFIRMATION: {
                if (this.layoutState == LayoutState.CONFIRMATION) break;
                this.removeAllViews();
                this.addConfirmationView();
            }
        }
        this.layoutState = newLayoutState;
    }

    private void addConfirmationView() {
        if (this.cachedConfirmationView == null) {
            try {
                this.cachedConfirmationView = LayoutInflater.from((Context)this.getContext()).inflate(this.confirmationLayoutResId, (ViewGroup)this, false);
            }
            catch (Resources.NotFoundException exception) {
                throw new IllegalArgumentException("Must provide a valid layout resource.", exception);
            }
        }
        this.addView(this.cachedConfirmationView, (ViewGroup.LayoutParams)CONTENT_VIEW_LAYOUT_PARAMS);
    }

    private void addQuestionView() {
        if (this.cachedQuestionView == null) {
            try {
                View view = LayoutInflater.from((Context)this.getContext()).inflate(this.questionLayoutResId, (ViewGroup)this, false);
                this.cachedQuestionView = new DefaultQuestionView(view);
                this.cachedQuestionView.getPositiveButton().setOnClickListener(this.positiveButtonClickListener);
                this.cachedQuestionView.getNegativeButton().setOnClickListener(this.negativeButtonClickListener);
            }
            catch (Resources.NotFoundException exception) {
                throw new IllegalArgumentException("Must provide a valid layout resource.", exception);
            }
        }
        this.addView(this.cachedQuestionView.getView(), (ViewGroup.LayoutParams)CONTENT_VIEW_LAYOUT_PARAMS);
    }

    public void show() {
        this.setVisibility(0);
    }

    private void hide() {
        this.setVisibility(8);
    }

    private void checkDependenciesHaveBeenInjected() {
        if (this.amplifyStateTracker == null || this.logger == null) {
            throw new IllegalStateException("Dependencies must be injected before this method is called");
        }
    }

    private static enum LayoutState {
        QUESTION,
        CONFIRMATION;

    }

    private static enum UserOpinion {
        UNKNOWN,
        POSITIVE,
        NEGATIVE;

    }
}

