/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import com.github.stkent.amplify.tracking.interfaces.ITrackableEvent;
import com.github.stkent.amplify.tracking.interfaces.ITrackableEventsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseTrackableEventsManager<T>
implements ITrackableEventsManager<T> {
    private static final String AMPLIFY_TRACKING_KEY_PREFIX = "AMPLIFY_";
    private final ILogger logger;
    private final ISettings<T> settings;
    private final ConcurrentHashMap<ITrackableEvent, List<IEventCheck<T>>> internalMap;

    @NonNull
    protected abstract String getTrackingKeySuffix();

    @NonNull
    protected abstract T defaultTrackingValue();

    @NonNull
    protected abstract T getUpdatedTrackingValue(@NonNull T var1);

    protected BaseTrackableEventsManager(@NonNull ILogger logger, @NonNull ISettings<T> settings) {
        this.logger = logger;
        this.settings = settings;
        this.internalMap = new ConcurrentHashMap();
    }

    @Override
    public void trackEvent(@NonNull ITrackableEvent event, @NonNull IEventCheck<T> eventCheck) {
        if (!this.isTrackingEvent(event)) {
            this.internalMap.put(event, new ArrayList());
        }
        this.internalMap.get(event).add(eventCheck);
        this.logger.d(this.internalMap.get(event).toString());
    }

    @Override
    public void notifyEventTriggered(@NonNull ITrackableEvent event) {
        if (this.isTrackingEvent(event)) {
            T cachedTrackingValue = this.getCachedTrackingValue(event);
            T updatedTrackingValue = this.getUpdatedTrackingValue(cachedTrackingValue);
            if (!updatedTrackingValue.equals(cachedTrackingValue)) {
                this.logger.d(IEventCheck.class.getSimpleName() + " updating event value from: " + cachedTrackingValue + " to " + updatedTrackingValue);
            }
            this.settings.writeTrackingValue(this.getTrackingKey(event), updatedTrackingValue);
        }
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        for (Map.Entry<ITrackableEvent, List<IEventCheck<T>>> eventCheckSet : this.internalMap.entrySet()) {
            ITrackableEvent event = eventCheckSet.getKey();
            for (IEventCheck<T> eventCheck : eventCheckSet.getValue()) {
                T cachedEventValue = this.getCachedTrackingValue(event);
                this.logger.d(this.getTrackingKey(event) + ": " + eventCheck.getStatusString(cachedEventValue));
                if (eventCheck.shouldAllowFeedbackPrompt(cachedEventValue)) continue;
                this.logger.d("Blocking feedback for event: " + event + " because of check: " + eventCheck);
                return false;
            }
        }
        return true;
    }

    protected ILogger getLogger() {
        return this.logger;
    }

    private boolean isTrackingEvent(@NonNull ITrackableEvent event) {
        return this.internalMap.containsKey(event);
    }

    private String getTrackingKey(@NonNull ITrackableEvent event) {
        return AMPLIFY_TRACKING_KEY_PREFIX + event.getTrackingKey() + "_" + this.getTrackingKeySuffix().toUpperCase();
    }

    private T getCachedTrackingValue(@NonNull ITrackableEvent event) {
        T value = this.settings.readTrackingValue(this.getTrackingKey(event));
        return value != null ? value : this.defaultTrackingValue();
    }
}

