/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.checks;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public class WarmUpDaysCheck
implements IEventCheck<Long> {
    private final long warmUpPeriodDays;

    public WarmUpDaysCheck(long warmUpPeriodDays) {
        this.warmUpPeriodDays = warmUpPeriodDays;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull Long cachedEventValue) {
        return cachedEventValue != Long.MAX_VALUE && SystemTimeUtil.currentTimeMillis() - cachedEventValue > TimeUnit.DAYS.toMillis(this.warmUpPeriodDays);
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull Long cachedEventValue) {
        Long daysSinceFirstEvent = TimeUnit.MILLISECONDS.toDays(SystemTimeUtil.currentTimeMillis() - cachedEventValue);
        return "Warm-up period: " + this.warmUpPeriodDays + " days. Time since first event: " + daysSinceFirstEvent + " days.";
    }
}

