/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.views;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TextView;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.utils.StringUtils;
import com.github.stkent.amplify.views.QuestionView;

public class DefaultQuestionView
implements QuestionView {
    @NonNull
    private final View view;
    @NonNull
    private final TextView questionTextView;
    @Nullable
    private final TextView titleTextView;
    @NonNull
    private final View positiveButton;
    @NonNull
    private final View negativeButton;

    public DefaultQuestionView(@NonNull View view) {
        this.view = view;
        this.titleTextView = (TextView)view.findViewById(R.id.amp_title_text_view);
        this.questionTextView = (TextView)view.findViewById(R.id.amp_question_text_view);
        if (this.questionTextView == null) {
            throw new IllegalArgumentException("You must supply a layout that includes a TextView with id amp_question_text_view");
        }
        this.positiveButton = view.findViewById(R.id.amp_positive_button);
        if (this.positiveButton == null) {
            throw new IllegalArgumentException("You must supply a layout that includes a View with id amp_positive_button");
        }
        this.negativeButton = view.findViewById(R.id.amp_negative_button);
        if (this.negativeButton == null) {
            throw new IllegalArgumentException("You must supply a layout that includes a View with id amp_negative_button");
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this.view;
    }

    @Override
    @NonNull
    public View getPositiveButton() {
        return this.positiveButton;
    }

    @Override
    @NonNull
    public View getNegativeButton() {
        return this.negativeButton;
    }

    @Override
    public void setQuestion(@NonNull String question) {
        this.questionTextView.setText((CharSequence)question);
    }

    @Override
    public void setTitle(@Nullable String title) {
        if (this.titleTextView != null) {
            if (StringUtils.isBlank(title)) {
                this.titleTextView.setVisibility(8);
            } else {
                this.titleTextView.setText((CharSequence)title);
            }
        }
    }
}

