/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCheck;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentChecksManager;
import java.util.ArrayList;
import java.util.List;

public class EnvironmentChecksManager
implements IEnvironmentChecksManager {
    @NonNull
    private final IEnvironmentCapabilitiesProvider environmentInfoProvider;
    @NonNull
    private final List<IEnvironmentCheck> environmentChecks = new ArrayList<IEnvironmentCheck>();

    public EnvironmentChecksManager(@NonNull IEnvironmentCapabilitiesProvider environmentInfoProvider) {
        this.environmentInfoProvider = environmentInfoProvider;
    }

    @Override
    public void addEnvironmentCheck(@NonNull IEnvironmentCheck environmentCheck) {
        this.environmentChecks.add(environmentCheck);
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        for (IEnvironmentCheck environmentCheck : this.environmentChecks) {
            if (environmentCheck.shouldAllowFeedbackPrompt(this.environmentInfoProvider)) continue;
            return false;
        }
        return true;
    }
}

