/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.trackers;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.ApplicationInfoProvider;
import com.github.stkent.amplify.tracking.Settings;
import com.github.stkent.amplify.tracking.interfaces.IApplicationInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import com.github.stkent.amplify.tracking.trackers.EventTracker;

public class LastVersionTracker
extends EventTracker<String> {
    public LastVersionTracker(@NonNull ILogger logger, @NonNull Context applicationContext) {
        this(logger, (ISettings<String>)new Settings<String>(applicationContext, logger), (IApplicationInfoProvider)new ApplicationInfoProvider(applicationContext));
    }

    protected LastVersionTracker(@NonNull ILogger logger, @NonNull ISettings<String> settings, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        super(logger, settings, applicationInfoProvider);
    }

    @Override
    @NonNull
    protected String getTrackingKeySuffix() {
        return this.getClass().getSimpleName();
    }

    @Override
    @NonNull
    public String defaultTrackingValue() {
        return "";
    }

    @Override
    @NonNull
    public String getUpdatedTrackingValue(@NonNull String cachedTrackingValue) {
        try {
            return this.getApplicationInfoProvider().getVersionName();
        }
        catch (PackageManager.NameNotFoundException e) {
            this.getLogger().d("Could not read current app version name.");
            return cachedTrackingValue;
        }
    }
}

