/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.checks;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IApplicationInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;

public final class MaximumCountCheck
implements IEventCheck<Integer> {
    private final int maximumCount;

    public MaximumCountCheck(int maximumCount) {
        this.maximumCount = maximumCount;
    }

    @Override
    public boolean shouldBlockFeedbackPrompt(@NonNull Integer cachedEventValue, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        return cachedEventValue >= this.maximumCount;
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull Integer cachedEventValue, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        return "Maximum allowed event count: " + this.maximumCount + ". Current event count: " + cachedEventValue + ".";
    }
}

