/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.tracking.interfaces.IApplicationInfoProvider;
import com.github.stkent.amplify.utils.ApplicationUtils;

public class ApplicationInfoProvider
implements IApplicationInfoProvider {
    private final Context applicationContext;

    public ApplicationInfoProvider(@NonNull Context context) {
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    @NonNull
    public String getVersionName() throws PackageManager.NameNotFoundException {
        return ApplicationUtils.getPackageInfo((Context)this.applicationContext, (int)0).versionName;
    }

    @Override
    @NonNull
    public String getApplicationVersionDisplayString() throws PackageManager.NameNotFoundException {
        int applicationVersionCode = ApplicationUtils.getPackageInfo((Context)this.applicationContext, (int)0).versionCode;
        return this.getVersionName() + " (" + applicationVersionCode + ")";
    }

    @Override
    @NonNull
    public String getFeedbackEmailAddress() throws IllegalStateException {
        try {
            return this.applicationContext.getString(R.string.amp_feedback_email);
        }
        catch (Resources.NotFoundException e) {
            throw new IllegalArgumentException("R.string.amp_feedback_emailresource not found, you must set this in your strings file for the feedback util to function", e);
        }
    }
}

