/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import java.util.concurrent.TimeUnit;

public class WarmupDaysCheck
implements IEventCheck<Long> {
    private final long warmupPeriodDays;

    public WarmupDaysCheck(long warmupPeriodDays) {
        this.warmupPeriodDays = warmupPeriodDays;
    }

    @Override
    public boolean shouldBlockFeedbackPrompt(@NonNull Long cachedEventValue, @NonNull Context applicationContext) {
        return System.currentTimeMillis() - cachedEventValue >= TimeUnit.DAYS.toMillis(this.warmupPeriodDays);
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull Long cachedEventValue, @NonNull Context applicationContext) {
        Long daysSinceLastEvent = TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - cachedEventValue);
        return "Warmup period: " + this.warmupPeriodDays + " days. Time since last event: " + daysSinceLastEvent + " days.";
    }
}

