/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.tracking.AmplifyStateTracker;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.ISettings;

public final class Settings
implements ISettings {
    private static final String SHARED_PREFERENCES_NAME = "AMPLIFY_SHARED_PREFERENCES_NAME";
    private static Settings sharedInstance;
    private final SharedPreferences sharedPreferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Settings getSharedInstance(@NonNull Context context) {
        Class<AmplifyStateTracker> clazz = AmplifyStateTracker.class;
        synchronized (AmplifyStateTracker.class) {
            if (sharedInstance == null) {
                sharedInstance = new Settings(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private Settings(@NonNull Context applicationContext) {
        this.sharedPreferences = applicationContext.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
    }

    @Override
    public int getTotalEventCount(@NonNull IEvent event) {
        String key = this.generateTotalEventCountTrackingKey(event);
        return this.sharedPreferences.getInt(key, 0);
    }

    @Override
    public void setTotalEventCount(@NonNull IEvent event, int totalEventCount) {
        String key = this.generateTotalEventCountTrackingKey(event);
        this.sharedPreferences.edit().putInt(key, totalEventCount).apply();
    }

    @Override
    public long getLastEventTime(@NonNull IEvent event) {
        String key = this.generateTotalEventCountTrackingKey(event);
        return this.sharedPreferences.getLong(key, 0L);
    }

    @Override
    public void setLastEventTime(@NonNull IEvent event, long lastEventTime) {
        String key = this.generateLastEventTimeTrackingKey(event);
        this.sharedPreferences.edit().putLong(key, lastEventTime).apply();
    }

    @Override
    @Nullable
    public String getLastEventVersion(@NonNull IEvent event) {
        String key = this.generateTotalEventCountTrackingKey(event);
        return this.sharedPreferences.getString(key, null);
    }

    @Override
    public void setLastEventVersion(@NonNull IEvent event, @NonNull String lastEventVersion) {
        String key = this.generateLastEventVersionTrackingKey(event);
        this.sharedPreferences.edit().putString(key, lastEventVersion).apply();
    }

    @Override
    public void reset() {
        this.sharedPreferences.edit().clear().apply();
    }

    private String generateTotalEventCountTrackingKey(@NonNull IEvent event) {
        return "TOTAL_EVENT_COUNT_" + event.getTrackingKey();
    }

    private String generateLastEventTimeTrackingKey(@NonNull IEvent event) {
        return "LAST_EVENT_TIME_" + event.getTrackingKey();
    }

    private String generateLastEventVersionTrackingKey(@NonNull IEvent event) {
        return "LAST_EVENT_VERSION_" + event.getTrackingKey();
    }
}

