/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public final class Question {
    private static final String DEFAULT_POSITIVE_BUTTON_TEXT = "Yes";
    private static final String DEFAULT_NEGATIVE_BUTTON_TEXT = "No";
    @NonNull
    private final String title;
    @NonNull
    private final String positiveButtonText;
    @NonNull
    private final String negativeButtonText;

    protected Question(@NonNull String title, @NonNull String positiveButtonText, @NonNull String negativeButtonText) {
        this.title = title;
        this.positiveButtonText = positiveButtonText;
        this.negativeButtonText = negativeButtonText;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getPositiveButtonText() {
        return this.positiveButtonText;
    }

    @NonNull
    public String getNegativeButtonText() {
        return this.negativeButtonText;
    }

    public static final class Builder {
        @NonNull
        private final String title;
        @Nullable
        private String positiveButtonText;
        @Nullable
        private String negativeButtonText = "No";

        public static Builder withTitle(@NonNull String title) {
            return new Builder(title);
        }

        private Builder(@NonNull String title) {
            this.title = title;
        }

        @NonNull
        public Builder andPositiveButtonText(@Nullable String newPositiveButtonText) {
            this.positiveButtonText = newPositiveButtonText;
            return this;
        }

        @NonNull
        public Builder andNegativeButtonText(@Nullable String newNegativeButtonText) {
            this.negativeButtonText = newNegativeButtonText;
            return this;
        }

        @NonNull
        public Question build() {
            String resolvedPositiveButtonText = this.positiveButtonText != null ? this.positiveButtonText : Question.DEFAULT_POSITIVE_BUTTON_TEXT;
            String resolvedNegativeButtonText = this.negativeButtonText != null ? this.negativeButtonText : Question.DEFAULT_NEGATIVE_BUTTON_TEXT;
            return new Question(this.title, resolvedPositiveButtonText, resolvedNegativeButtonText);
        }
    }
}

