/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.stkent.amplify.DefaultQuestionView;
import com.github.stkent.amplify.Question;
import com.github.stkent.amplify.QuestionView;
import com.github.stkent.amplify.R;

public class AmplifyView
extends FrameLayout {
    private static final FrameLayout.LayoutParams CONTENT_VIEW_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-1, -1);
    private UserOpinion userOpinion = UserOpinion.UNKNOWN;
    private final Question userOpinionQuestion = Question.Builder.withTitle("First question title").andPositiveButtonText("Positive button").andNegativeButtonText("Negative button").build();
    private final Question positiveFeedbackQuestion = Question.Builder.withTitle("Second question (+ve)").andPositiveButtonText("Positive button").andNegativeButtonText("Negative button").build();
    private final Question criticalFeedbackQuestion = Question.Builder.withTitle("Second question (-ve)").andPositiveButtonText("Positive button").andNegativeButtonText("Negative button").build();
    @LayoutRes
    private int questionLayoutResId;
    @LayoutRes
    private int confirmationLayoutResId;
    @Nullable
    private QuestionView cachedQuestionView;
    @Nullable
    private View cachedConfirmationView;
    private final View.OnClickListener positiveButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            switch (AmplifyView.this.userOpinion) {
                case UNKNOWN: {
                    AmplifyView.this.userOpinion = UserOpinion.POSITIVE;
                    AmplifyView.this.askSecondQuestion();
                    break;
                }
                case POSITIVE: {
                    AmplifyView.this.thankUser();
                    break;
                }
                case NEGATIVE: {
                    AmplifyView.this.thankUser();
                    break;
                }
            }
        }
    };
    private final View.OnClickListener negativeButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            switch (AmplifyView.this.userOpinion) {
                case UNKNOWN: {
                    AmplifyView.this.userOpinion = UserOpinion.NEGATIVE;
                    AmplifyView.this.askSecondQuestion();
                    break;
                }
                case POSITIVE: {
                    AmplifyView.this.hide();
                    break;
                }
                case NEGATIVE: {
                    AmplifyView.this.hide();
                    break;
                }
            }
        }
    };

    public AmplifyView(Context context) {
        this(context, null);
    }

    public AmplifyView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AmplifyView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Amplify, 0, 0);
        this.questionLayoutResId = typedArray.getResourceId(R.styleable.Amplify_amplify_question_layout, 0);
        this.confirmationLayoutResId = typedArray.getResourceId(R.styleable.Amplify_amplify_confirmation_layout, 0);
        typedArray.recycle();
        this.askFirstQuestion();
    }

    private void askFirstQuestion() {
        this.setContentLayoutForNewState(LayoutState.QUESTION);
        if (this.cachedQuestionView != null) {
            this.cachedQuestionView.setQuestion(this.userOpinionQuestion);
        }
    }

    private void askSecondQuestion() {
        this.setContentLayoutForNewState(LayoutState.QUESTION);
        if (this.cachedQuestionView != null) {
            if (this.userOpinion == UserOpinion.POSITIVE) {
                this.cachedQuestionView.setQuestion(this.positiveFeedbackQuestion);
            } else if (this.userOpinion == UserOpinion.NEGATIVE) {
                this.cachedQuestionView.setQuestion(this.criticalFeedbackQuestion);
            }
        }
    }

    private void thankUser() {
        this.setContentLayoutForNewState(LayoutState.CONFIRMATION);
    }

    private void setContentLayoutForNewState(@NonNull LayoutState newLayoutState) {
        switch (newLayoutState) {
            case QUESTION: {
                this.removeAllViews();
                this.addQuestionView();
                break;
            }
            case CONFIRMATION: {
                this.removeAllViews();
                this.addConfirmationView();
            }
        }
    }

    private void addConfirmationView() {
        if (this.cachedConfirmationView == null) {
            try {
                this.cachedConfirmationView = LayoutInflater.from((Context)this.getContext()).inflate(this.confirmationLayoutResId, (ViewGroup)this, false);
            }
            catch (Resources.NotFoundException exception) {
                throw new IllegalArgumentException("Must provide a valid layout resource.", exception);
            }
        }
        this.addView(this.cachedConfirmationView, (ViewGroup.LayoutParams)CONTENT_VIEW_LAYOUT_PARAMS);
    }

    private void addQuestionView() {
        if (this.cachedQuestionView == null) {
            try {
                View view = LayoutInflater.from((Context)this.getContext()).inflate(this.questionLayoutResId, (ViewGroup)this, false);
                this.cachedQuestionView = new DefaultQuestionView(view);
                this.cachedQuestionView.getPositiveButton().setOnClickListener(this.positiveButtonClickListener);
                this.cachedQuestionView.getNegativeButton().setOnClickListener(this.negativeButtonClickListener);
            }
            catch (Resources.NotFoundException exception) {
                throw new IllegalArgumentException("Must provide a valid layout resource.", exception);
            }
        }
        this.addView(this.cachedQuestionView.getView(), (ViewGroup.LayoutParams)CONTENT_VIEW_LAYOUT_PARAMS);
    }

    private void hide() {
        this.setVisibility(8);
    }

    private static enum LayoutState {
        QUESTION,
        CONFIRMATION;

    }

    private static enum UserOpinion {
        UNKNOWN,
        POSITIVE,
        NEGATIVE;

    }
}

