/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import java.lang.reflect.Field;

public class DatabaseUtils {
    private DatabaseUtils() {
    }

    public static Field[] getFieldsFromClass(Class klass) {
        Field[] allFields = null;
        Class currentKlass = klass;
        do {
            Field[] fields = currentKlass.getDeclaredFields();
            if (allFields != null) {
                if (fields.length > 0) {
                    int aLen = allFields.length;
                    int bLen = fields.length;
                    Field[] newFieldsArray = new Field[aLen + bLen];
                    System.arraycopy(allFields, 0, newFieldsArray, 0, aLen);
                    System.arraycopy(fields, 0, newFieldsArray, aLen, bLen);
                    fields = newFieldsArray;
                } else {
                    fields = allFields;
                }
            }
            allFields = fields;
        } while ((currentKlass = currentKlass.getSuperclass()) != null);
        return allFields;
    }

    public static int getIntDatatype(String dataType) {
        if (dataType.equals("Null")) {
            return 0;
        }
        if (dataType.equals("Integer")) {
            return 4;
        }
        if (dataType.equals("Boolean")) {
            return 16;
        }
        if (dataType.equals("Double")) {
            return 8;
        }
        if (dataType.equals("String")) {
            return 12;
        }
        if (dataType.equals("Datetime")) {
            return 91;
        }
        if (dataType.equals("Blob")) {
            return 2004;
        }
        return -1;
    }

    public static boolean isSystemTable(String tableName) {
        return tableName.equals("TABLE_MAP") || tableName.equals("SCHEMA_SETTINGS");
    }

    public static String getDatabaseAsName(String tableName, String colName) {
        return (tableName + colName).toLowerCase();
    }

    public static String normaliseTableColumnAsName(String name) {
        return name.replace(DatabaseUtils.getTableColumnSeparator(), "").toLowerCase();
    }

    public static String getTableColumnSeparator() {
        return ".";
    }
}

