/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.stonecraft.datastore.AndroidDBConnection;
import com.stonecraft.datastore.DatabaseUpdater;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.DatastoreTransaction;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.OnConnectionListener;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseTable;
import com.stonecraft.datastore.view.SQLiteColumn;
import com.stonecraft.datastore.view.SQLiteTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private SQLiteDatabase myDBInUse;
    private final int myVersion;
    private DbSchemaModel myDBSchema;
    private AndroidDBConnection myConnection;
    private OnConnectionListener myConnectionCreatedListener;

    protected DatabaseHelper(Context context, AndroidDBConnection connection, DbSchemaModel schema, OnConnectionListener listener) {
        super(context, schema.getName() + ".sqlite", null, schema.getVersion());
        this.myVersion = schema.getVersion();
        this.myDBSchema = schema;
        this.myConnection = connection;
        this.myConnectionCreatedListener = listener;
    }

    public void onCreate(SQLiteDatabase db) {
        this.myDBInUse = db;
        this.createDatabase(db);
        this.myDBInUse = null;
        if (this.myConnectionCreatedListener != null) {
            this.myConnectionCreatedListener.onConnectionCreated(Datastore.getDataStore(this.myDBSchema.getName()));
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        try {
            this.myDBInUse = db;
            int value = this.myConnection.doesTableExist("TABLE_MAP");
            if (this.myConnection.doesTableExist("TABLE_MAP") == 0) {
                DatabaseUpdater.createDataMapTables(this.myConnection, this.myDBSchema);
                if (this.myConnection.doesTableExist("sqlite_master") == 0) {
                    this.populateInitialDatamapTable(this.myDBInUse, oldVersion);
                }
            }
            DatabaseUpdater updater = new DatabaseUpdater(this.myConnection);
            this.myDBSchema = updater.update(this.myDBSchema);
            if (this.myConnectionCreatedListener != null) {
                this.myConnectionCreatedListener.onUpgrade(Datastore.getDataStore(this.myDBSchema.getName()));
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Failed to update database", e);
        }
        this.myDBInUse = null;
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        try {
            this.myDBInUse = db;
            int value = this.myConnection.doesTableExist("TABLE_MAP");
            if (this.myConnection.doesTableExist("TABLE_MAP") == 0) {
                DatabaseUpdater.createDataMapTables(this.myConnection, this.myDBSchema);
                if (this.myConnection.doesTableExist("sqlite_master") == 0) {
                    this.populateInitialDatamapTable(this.myDBInUse, this.myDBSchema.getVersion() - 1);
                }
            }
            this.myDBInUse = null;
            if (this.myConnectionCreatedListener != null) {
                this.myConnectionCreatedListener.onOpen(Datastore.getDataStore(this.myDBSchema.getName()));
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Could not create db schema from database");
        }
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        if (this.myDBInUse == null) {
            this.myDBInUse = super.getWritableDatabase();
            return this.myDBInUse;
        }
        return this.myDBInUse;
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        if (this.myDBInUse == null) {
            this.myDBInUse = super.getReadableDatabase();
            return this.myDBInUse;
        }
        return this.myDBInUse;
    }

    public synchronized void close() {
        if (this.myConnectionCreatedListener != null) {
            this.myConnectionCreatedListener.onClose();
        }
        super.close();
    }

    protected int getVersion() {
        return this.myVersion;
    }

    void reconnect() {
        if (!this.myDBInUse.isOpen()) {
            this.myDBInUse = SQLiteDatabase.openDatabase((String)this.myDBInUse.getPath(), null, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabase(SQLiteDatabase db) {
        try {
            List<String> createStatements = this.myDBSchema.getTableCreateStmts();
            db.beginTransaction();
            for (String statement : createStatements) {
                db.execSQL(statement);
            }
            new DatabaseUpdater(this.myConnection).update(this.myDBSchema);
            db.setTransactionSuccessful();
            Log.i((String)"Databasestore Helper", (String)"The Database has been created successfully");
        }
        catch (Exception e) {
            Log.e((String)"Databasestore Helper", (String)("Could not create the database. [" + e + "]"));
            Log.e((String)"Databasestore Helper", (String)Log.getStackTraceString((Throwable)e));
        }
        finally {
            db.endTransaction();
        }
    }

    private void populateInitialDatamapTable(SQLiteDatabase db, int oldVersion) {
        Cursor cursor = db.query("sqlite_master", new String[]{"sql"}, "type = 'table'", null, null, null, null);
        cursor.moveToFirst();
        DbSchemaModel schema = new DbSchemaModel();
        while (!cursor.isAfterLast()) {
            String createStatement = cursor.getString(0);
            DatabaseTable table = this.parseCreateStatement(createStatement);
            if (!table.getName().equals("android_metadata") && !table.getName().equals("sqlite_sequence")) {
                schema.addTable(table);
            }
            cursor.moveToNext();
        }
        if (!schema.getTables().isEmpty()) {
            try {
                schema.setName(this.myDBSchema.getName());
                schema.setVersion(oldVersion);
                DatastoreTransaction txn = new DatastoreTransaction();
                txn.setConnection(this.myConnection);
                DatabaseUpdater.populateDatamapTables(txn, schema);
                txn.run();
            }
            catch (DatabaseException e) {
                throw new RuntimeException("Failed to populate the datamap table with the tables parsed from the master table [" + e + "]");
            }
        }
    }

    private DatabaseTable parseCreateStatement(String createStatement) {
        int tableNameStartIndex = "CREATE TABLE".length() + 1;
        String tableName = createStatement.substring(tableNameStartIndex, createStatement.indexOf("(", tableNameStartIndex)).trim();
        SQLiteTable table = new SQLiteTable(tableName, null);
        HashMap<String, TempColumn> colsMap = new HashMap<String, TempColumn>();
        int firstBraketIndex = createStatement.indexOf("(") + 1;
        int lastBracketIndex = createStatement.lastIndexOf(")");
        List<String> columns = StringUtils.convertDelimitedStringToList(createStatement.substring(firstBraketIndex, lastBracketIndex), ',', '\\');
        for (String string : columns) {
            String[] columnAttribs = string.split(" ");
            if (columnAttribs[0].equals("PRIMARY")) {
                int primaryKeyBraketIndex = createStatement.indexOf("(", firstBraketIndex) + 1;
                int primaryKeyCloseBraketIndex = createStatement.indexOf(")", primaryKeyBraketIndex);
                String compositeKeys = createStatement.substring(primaryKeyBraketIndex, primaryKeyCloseBraketIndex);
                List<String> compositeKeyList = StringUtils.convertDelimitedStringToList(compositeKeys, ',', '\\');
                for (String colName : compositeKeyList) {
                    if (!colsMap.containsKey(colName)) continue;
                    TempColumn col = (TempColumn)colsMap.get(colName);
                    col.myIsNullable = false;
                    col.myIsPrimarykey = true;
                }
                break;
            }
            TempColumn col = new TempColumn();
            col.myIsNullable = true;
            col.myName = columnAttribs[0].trim();
            for (int i = 1; i < columnAttribs.length; ++i) {
                String attrib = columnAttribs[i].trim();
                if (attrib.equals("INTEGER")) {
                    col.myType = 4;
                    continue;
                }
                if (attrib.equals("REAL")) {
                    col.myType = 8;
                    continue;
                }
                if (attrib.equals("TEXT")) {
                    col.myType = 12;
                    continue;
                }
                if (attrib.equals("BLOB")) {
                    col.myType = 2004;
                    continue;
                }
                if (attrib.equals("PRIMARY")) {
                    col.myIsNullable = false;
                    col.myIsPrimarykey = true;
                    continue;
                }
                if (attrib.equals("AUTOINCREMENT")) {
                    col.myIsAutoIncrement = true;
                    continue;
                }
                if (!attrib.equals("NULL")) continue;
                col.myIsNullable = false;
            }
            colsMap.put(col.myName, col);
        }
        for (Map.Entry entry : colsMap.entrySet()) {
            TempColumn col = (TempColumn)entry.getValue();
            table.addColumn(new SQLiteColumn(col.myName, col.myType, 0, col.myIsPrimarykey, col.myIsNullable, col.myIsAutoIncrement));
        }
        return table;
    }

    private static class TempColumn {
        String myName;
        int myType;
        boolean myIsPrimarykey;
        boolean myIsAutoIncrement;
        boolean myIsNullable;

        private TempColumn() {
        }
    }
}

